/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;

public class LockedEntriesInfo {
    private static final long DEADLOCK_DETECTION_TIMEOUT = 500L;
    private final Map<Long, LockedEntries> lockedEntriesPerThread = new ConcurrentHashMap<Long, LockedEntries>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLockEntries(GridCacheEntryEx[] entries) {
        long threadId = Thread.currentThread().getId();
        LockedEntries lockedEntries = new LockedEntries(entries);
        this.lockedEntriesPerThread.put(threadId, lockedEntries);
        boolean wasInterrupted = false;
        try {
            for (int i = 0; i < entries.length; ++i) {
                GridCacheEntryEx entry = entries[i];
                if (entry == null) continue;
                boolean retry = false;
                while (!entry.tryLockEntry(500L)) {
                    wasInterrupted |= Thread.interrupted();
                    if (!this.hasLockCollisions(entry, lockedEntries)) continue;
                    retry = true;
                    break;
                }
                if (!retry && entry.obsolete()) {
                    entry.unlockEntry();
                    retry = true;
                }
                if (retry) {
                    lockedEntries.lockedIdx = -1;
                    for (int j = 0; j < i; ++j) {
                        if (entries[j] == null) continue;
                        entries[j].unlockEntry();
                    }
                    boolean bl = false;
                    return bl;
                }
                lockedEntries.lockedIdx = i;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
            this.lockedEntriesPerThread.remove(threadId);
        }
    }

    private boolean hasLockCollisions(GridCacheEntryEx entry, LockedEntries curLockedEntries) {
        for (Map.Entry<Long, LockedEntries> other : this.lockedEntriesPerThread.entrySet()) {
            LockedEntries otherLockedEntries = other.getValue();
            if (otherLockedEntries == curLockedEntries || otherLockedEntries.ts > curLockedEntries.ts) continue;
            GridCacheEntryEx[] otherThreadLocks = otherLockedEntries.entries;
            int otherThreadLockedIdx = otherLockedEntries.lockedIdx;
            for (int i = 0; i <= otherThreadLockedIdx; ++i) {
                if (otherThreadLocks[i] != entry) continue;
                return true;
            }
        }
        return false;
    }

    private static class LockedEntries {
        private final long ts = System.nanoTime();
        private final GridCacheEntryEx[] entries;
        private volatile int lockedIdx = -1;

        private LockedEntries(GridCacheEntryEx[] entries) {
            this.entries = entries;
        }
    }
}

