/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.audit;

import java.util.List;
import org.apache.iotdb.db.audit.AuditLogOperation;
import org.apache.iotdb.db.audit.AuditLogStorage;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.utils.DateTimeUtils;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.query.control.clientsession.ClientSession;
import org.apache.iotdb.db.query.control.clientsession.IClientSession;
import org.apache.iotdb.db.service.IoTDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogger {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogger.class);
    private static final Logger AUDIT_LOGGER = LoggerFactory.getLogger((String)"IoTDB_AUDIT_LOGGER");
    public static final String LOG = "log";
    public static final String USERNAME = "username";
    public static final String ADDRESS = "address";
    public static final String AUDIT_LOG_DEVICE = "root.__system.audit._%s";
    public static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    public static final List<AuditLogStorage> auditLogStorageList = config.getAuditLogStorage();
    public static final List<AuditLogOperation> auditLogOperationList = config.getAuditLogOperation();

    public static void log(String log, AuditLogOperation operation) {
        IClientSession currSession = SessionManager.getInstance().getCurrSession();
        String username = "";
        String address = "";
        if (currSession != null) {
            ClientSession clientSession = (ClientSession)currSession;
            String clientAddress = clientSession.getClientAddress();
            int clientPort = ((ClientSession)currSession).getClientPort();
            address = String.format("%s:%s", clientAddress, clientPort);
            username = currSession.getUsername();
        }
        if (auditLogOperationList.contains((Object)operation)) {
            if (auditLogStorageList.contains((Object)AuditLogStorage.IOTDB)) {
                try {
                    InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath(String.format(AUDIT_LOG_DEVICE, username)), DateTimeUtils.currentTime(), new String[]{LOG, USERNAME, ADDRESS}, new String[]{log, username, address});
                    if (IoTDB.serviceProvider == null) {
                        return;
                    }
                    IoTDB.serviceProvider.getExecutor().insert(insertRowPlan);
                }
                catch (IllegalPathException | QueryProcessException e) {
                    logger.error("write audit log series error,", (Throwable)e);
                }
            }
            if (auditLogStorageList.contains((Object)AuditLogStorage.LOGGER)) {
                AUDIT_LOGGER.info("user:{},address:{},log:{}", new Object[]{username, address, log});
            }
        }
    }

    public static void log(String log, AuditLogOperation operation, boolean isNativeApi) {
        if (isNativeApi) {
            if (config.isEnableAuditLogForNativeInsertApi()) {
                AuditLogger.log(log, operation);
            }
        } else {
            AuditLogger.log(log, operation);
        }
    }
}

