/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.protocol.pipeconsensus;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.pipe.receiver.IoTDBReceiverAgent;
import org.apache.iotdb.commons.pipe.sink.payload.pipeconsensus.request.PipeConsensusRequestType;
import org.apache.iotdb.commons.pipe.sink.payload.pipeconsensus.request.PipeConsensusRequestVersion;
import org.apache.iotdb.commons.pipe.sink.payload.pipeconsensus.request.PipeConsensusTransferFilePieceReq;
import org.apache.iotdb.commons.pipe.sink.payload.pipeconsensus.response.PipeConsensusTransferFilePieceResp;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.utils.RetryUtils;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.exception.ConsensusGroupNotExistException;
import org.apache.iotdb.consensus.pipe.PipeConsensus;
import org.apache.iotdb.consensus.pipe.PipeConsensusServerImpl;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeName;
import org.apache.iotdb.consensus.pipe.thrift.TCommitId;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferResp;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.load.LoadFileException;
import org.apache.iotdb.db.pipe.consensus.metric.PipeConsensusReceiverMetrics;
import org.apache.iotdb.db.pipe.event.common.tsfile.aggregator.TsFileInsertionPointCounter;
import org.apache.iotdb.db.pipe.receiver.protocol.pipeconsensus.PipeConsensusReceiverAgent;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusDeleteNodeReq;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusTabletBinaryReq;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusTsFilePieceReq;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusTsFileSealReq;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusTsFileSealWithModReq;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.AbstractDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileResourceUtils;
import org.apache.iotdb.db.storageengine.load.LoadTsFileManager;
import org.apache.iotdb.db.storageengine.rescon.disk.FolderManager;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.DirectoryStrategyType;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConsensusReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusReceiver.class);
    private static final IoTDBConfig IOTDB_CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final long PIPE_CONSENSUS_RECEIVER_MAX_WAITING_TIME_IN_MS = (long)IOTDB_CONFIG.getConnectionTimeoutInMS() / 3L * (long)IOTDB_CONFIG.getIotConsensusV2PipelineSize();
    private static final long CLOSE_TSFILE_WRITER_MAX_WAIT_TIME_IN_MS = 5000L;
    private static final long RETRY_WAIT_TIME = 500L;
    private final RequestExecutor requestExecutor;
    private final PipeConsensus pipeConsensus;
    private final ConsensusGroupId consensusGroupId;
    private final ConsensusPipeName consensusPipeName;
    private final PipeConsensusTsFileWriterPool pipeConsensusTsFileWriterPool;
    private final ScheduledExecutorService scheduledTsFileWriterCheckerPool = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.PIPE_CONSENSUS_TSFILE_WRITER_CHECKER.getName());
    private Future<?> tsFileWriterCheckerFuture;
    private final List<String> receiveDirs = new ArrayList<String>();
    private final PipeConsensusReceiverMetrics pipeConsensusReceiverMetrics;
    private final FolderManager folderManager;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final ReadWriteLock tsFilePieceReadWriteLock = new ReentrantReadWriteLock(true);

    public PipeConsensusReceiver(PipeConsensus pipeConsensus, ConsensusGroupId consensusGroupId, ConsensusPipeName consensusPipeName) {
        this.pipeConsensus = pipeConsensus;
        this.consensusGroupId = consensusGroupId;
        this.pipeConsensusReceiverMetrics = new PipeConsensusReceiverMetrics(this);
        this.consensusPipeName = consensusPipeName;
        List<String> receiverBaseDirsName = Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getIotConsensusV2ReceiverFileDirs());
        try {
            this.initiateTsFileBufferFolder(receiverBaseDirsName);
        }
        catch (Exception e) {
            LOGGER.error("Fail to initiate file buffer folder, Error msg: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        try {
            this.folderManager = new FolderManager(this.receiveDirs, DirectoryStrategyType.SEQUENCE_STRATEGY);
            this.pipeConsensusTsFileWriterPool = new PipeConsensusTsFileWriterPool(consensusPipeName);
        }
        catch (Exception e) {
            LOGGER.error("Fail to create pipeConsensus receiver file folders allocation strategy because all disks of folders are full.", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.requestExecutor = new RequestExecutor(this.pipeConsensusReceiverMetrics, this.pipeConsensusTsFileWriterPool);
        MetricService.getInstance().addMetricSet((IMetricSet)this.pipeConsensusReceiverMetrics);
    }

    public TPipeConsensusTransferResp receive(TPipeConsensusTransferReq req) {
        long startNanos = System.nanoTime();
        TPipeConsensusTransferResp resp = this.preCheckForReceiver(req);
        if (resp != null) {
            this.releaseTsFileWriter(this.pipeConsensusTsFileWriterPool.tryToFindCorrespondingWriter(req.getCommitId()), false);
            return resp;
        }
        short rawRequestType = req.getType();
        if (PipeConsensusRequestType.isValidatedRequestType((short)rawRequestType)) {
            switch (PipeConsensusRequestType.valueOf((short)rawRequestType)) {
                case TRANSFER_TS_FILE_PIECE: 
                case TRANSFER_TS_FILE_PIECE_WITH_MOD: {
                    this.requestExecutor.onRequest(req, true, false);
                    resp = this.loadEvent(req);
                    break;
                }
                case TRANSFER_TS_FILE_SEAL: 
                case TRANSFER_TS_FILE_SEAL_WITH_MOD: {
                    resp = this.requestExecutor.onRequest(req, false, true);
                    break;
                }
                default: {
                    resp = this.requestExecutor.onRequest(req, false, false);
                }
            }
            long durationNanos = System.nanoTime() - startNanos;
            this.pipeConsensusReceiverMetrics.recordReceiveEventTimer(durationNanos);
            return resp;
        }
        TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_TYPE_ERROR, (String)String.format("PipeConsensus Unknown PipeRequestType %s.", rawRequestType));
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("PipeConsensus Unknown PipeRequestType, response status = {}.", (Object)status);
        }
        return new TPipeConsensusTransferResp(status);
    }

    private TPipeConsensusTransferResp preCheckForReceiver(TPipeConsensusTransferReq req) {
        ConsensusGroupId groupId = ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)req.getConsensusGroupId());
        PipeConsensusServerImpl impl = this.pipeConsensus.getImpl(groupId);
        if (impl == null) {
            String message = String.format("PipeConsensus-PipeName-%s: unexpected consensusGroupId %s", this.consensusPipeName, groupId);
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(message);
            }
            return new TPipeConsensusTransferResp(RpcUtils.getStatus((int)TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), (String)message));
        }
        if (impl.isReadOnly()) {
            String message = String.format("PipeConsensus-PipeName-%s: fail to receive because system is read-only.", this.consensusPipeName);
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(message);
            }
            return new TPipeConsensusTransferResp(RpcUtils.getStatus((int)TSStatusCode.SYSTEM_READ_ONLY.getStatusCode(), (String)message));
        }
        return null;
    }

    private TPipeConsensusTransferResp loadEvent(TPipeConsensusTransferReq req) {
        if (this.isClosed.get()) {
            return PipeConsensusReceiverAgent.closedResp(this.consensusPipeName.toString(), req.getCommitId());
        }
        try {
            short rawRequestType = req.getType();
            if (PipeConsensusRequestType.isValidatedRequestType((short)rawRequestType)) {
                switch (PipeConsensusRequestType.valueOf((short)rawRequestType)) {
                    case TRANSFER_TABLET_INSERT_NODE: {
                        return this.handleTransferTabletInsertNode(PipeConsensusTabletInsertNodeReq.fromTPipeConsensusTransferReq(req));
                    }
                    case TRANSFER_TABLET_BINARY: {
                        return this.handleTransferTabletBinary(PipeConsensusTabletBinaryReq.fromTPipeConsensusTransferReq(req));
                    }
                    case TRANSFER_DELETION: {
                        return this.handleTransferDeletion(PipeConsensusDeleteNodeReq.fromTPipeConsensusTransferReq(req));
                    }
                    case TRANSFER_TS_FILE_PIECE: {
                        return this.handleTransferFilePiece(PipeConsensusTsFilePieceReq.fromTPipeConsensusTransferReq(req), true);
                    }
                    case TRANSFER_TS_FILE_SEAL: {
                        return this.handleTransferFileSeal(PipeConsensusTsFileSealReq.fromTPipeConsensusTransferReq(req));
                    }
                    case TRANSFER_TS_FILE_PIECE_WITH_MOD: {
                        return this.handleTransferFilePiece(PipeConsensusTsFilePieceReq.fromTPipeConsensusTransferReq(req), false);
                    }
                    case TRANSFER_TS_FILE_SEAL_WITH_MOD: {
                        return this.handleTransferFileSealWithMods(PipeConsensusTsFileSealWithModReq.fromTPipeConsensusTransferReq(req));
                    }
                    case TRANSFER_TABLET_BATCH: {
                        LOGGER.info("PipeConsensus transfer batch hasn't been implemented yet.");
                    }
                }
            }
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_CONSENSUS_TYPE_ERROR, (String)String.format("Unknown PipeConsensusRequestType %s.", rawRequestType));
            LOGGER.warn("PipeConsensus-PipeName-{}: Unknown PipeRequestType, response status = {}.", (Object)this.consensusPipeName, (Object)status);
            return new TPipeConsensusTransferResp(status);
        }
        catch (Exception e) {
            String error = String.format("Serialization error during pipe receiving, %s", e);
            LOGGER.warn("PipeConsensus-PipeName-{}: {}", new Object[]{this.consensusPipeName, error, e});
            return new TPipeConsensusTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_ERROR, (String)error));
        }
    }

    private TPipeConsensusTransferResp handleTransferTabletInsertNode(PipeConsensusTabletInsertNodeReq req) throws ConsensusGroupNotExistException {
        PipeConsensusServerImpl impl = Optional.ofNullable(this.pipeConsensus.getImpl(this.consensusGroupId)).orElseThrow(() -> new ConsensusGroupNotExistException(this.consensusGroupId));
        InsertNode insertNode = req.getInsertNode();
        insertNode.markAsGeneratedByRemoteConsensusLeader();
        insertNode.setProgressIndex(ProgressIndexType.deserializeFrom((ByteBuffer)ByteBuffer.wrap(req.getProgressIndex())));
        return new TPipeConsensusTransferResp(impl.writeOnFollowerReplica((IConsensusRequest)insertNode));
    }

    private TPipeConsensusTransferResp handleTransferTabletBinary(PipeConsensusTabletBinaryReq req) throws ConsensusGroupNotExistException {
        PipeConsensusServerImpl impl = Optional.ofNullable(this.pipeConsensus.getImpl(this.consensusGroupId)).orElseThrow(() -> new ConsensusGroupNotExistException(this.consensusGroupId));
        InsertNode insertNode = req.convertToInsertNode();
        insertNode.markAsGeneratedByRemoteConsensusLeader();
        insertNode.setProgressIndex(ProgressIndexType.deserializeFrom((ByteBuffer)ByteBuffer.wrap(req.getProgressIndex())));
        return new TPipeConsensusTransferResp(impl.writeOnFollowerReplica((IConsensusRequest)insertNode));
    }

    private TPipeConsensusTransferResp handleTransferDeletion(PipeConsensusDeleteNodeReq req) throws ConsensusGroupNotExistException {
        PipeConsensusServerImpl impl = Optional.ofNullable(this.pipeConsensus.getImpl(this.consensusGroupId)).orElseThrow(() -> new ConsensusGroupNotExistException(this.consensusGroupId));
        AbstractDeleteDataNode planNode = req.getDeleteDataNode();
        planNode.markAsGeneratedByRemoteConsensusLeader();
        planNode.setProgressIndex(ProgressIndexType.deserializeFrom((ByteBuffer)ByteBuffer.wrap(req.getProgressIndex())));
        return new TPipeConsensusTransferResp(impl.writeOnFollowerReplica((IConsensusRequest)planNode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TPipeConsensusTransferResp handleTransferFilePiece(PipeConsensusTransferFilePieceReq req, boolean isSingleFile) {
        this.tsFilePieceReadWriteLock.readLock().lock();
        try {
            RandomAccessFile writingFileWriter;
            long startPreCheckNanos;
            block16: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("PipeConsensus-PipeName-{}: starting to receive tsFile pieces", (Object)this.consensusPipeName);
                }
                long startBorrowTsFileWriterNanos = System.nanoTime();
                PipeConsensusTsFileWriter tsFileWriter = this.pipeConsensusTsFileWriterPool.borrowCorrespondingWriter(req.getCommitId());
                startPreCheckNanos = System.nanoTime();
                this.pipeConsensusReceiverMetrics.recordBorrowTsFileWriterTimer(startPreCheckNanos - startBorrowTsFileWriterNanos);
                try {
                    this.updateWritingFileIfNeeded(tsFileWriter, req.getFileName(), isSingleFile);
                    File writingFile = tsFileWriter.getWritingFile();
                    writingFileWriter = tsFileWriter.getWritingFileWriter();
                    if (!this.isWritingFileOffsetNonCorrect(tsFileWriter, req.getStartWritingOffset())) break block16;
                    if (!writingFile.getName().endsWith(".tsfile")) {
                        writingFileWriter.setLength(0L);
                    }
                    TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_CONSENSUS_TRANSFER_FILE_OFFSET_RESET, (String)String.format("Request sender to reset file reader's offset from %s to %s.", req.getStartWritingOffset(), writingFileWriter.length()));
                    LOGGER.warn("PipeConsensus-PipeName-{}: File offset reset requested by receiver, response status = {}.", (Object)this.consensusPipeName, (Object)status);
                    PipeConsensusTransferFilePieceResp pipeConsensusTransferFilePieceResp = PipeConsensusTransferFilePieceResp.toTPipeConsensusTransferResp((TSStatus)status, (long)writingFileWriter.length());
                    return pipeConsensusTransferFilePieceResp;
                }
                catch (Exception e) {
                    LOGGER.warn("PipeConsensus-PipeName-{}: Failed to write file piece from req {}.", new Object[]{this.consensusPipeName, req, e});
                    TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_CONSENSUS_TRANSFER_FILE_ERROR, (String)String.format("Failed to write file piece, because %s", e.getMessage()));
                    try {
                        PipeConsensusTransferFilePieceResp endPreCheckNanos = PipeConsensusTransferFilePieceResp.toTPipeConsensusTransferResp((TSStatus)status, (long)-1L);
                        return endPreCheckNanos;
                    }
                    catch (IOException ex) {
                        PipeConsensusTransferFilePieceResp pipeConsensusTransferFilePieceResp = PipeConsensusTransferFilePieceResp.toTPipeConsensusTransferResp((TSStatus)status);
                        return pipeConsensusTransferFilePieceResp;
                    }
                    finally {
                        this.releaseTsFileWriter(tsFileWriter, false);
                    }
                }
            }
            long endPreCheckNanos = System.nanoTime();
            this.pipeConsensusReceiverMetrics.recordTsFilePiecePreCheckTime(endPreCheckNanos - startPreCheckNanos);
            writingFileWriter.write(req.getFilePiece());
            this.pipeConsensusReceiverMetrics.recordTsFilePieceWriteTime(System.nanoTime() - endPreCheckNanos);
            PipeConsensusTransferFilePieceResp pipeConsensusTransferFilePieceResp = PipeConsensusTransferFilePieceResp.toTPipeConsensusTransferResp((TSStatus)RpcUtils.SUCCESS_STATUS, (long)writingFileWriter.length());
            return pipeConsensusTransferFilePieceResp;
        }
        finally {
            this.tsFilePieceReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TPipeConsensusTransferResp handleTransferFileSeal(PipeConsensusTsFileSealReq req) {
        LOGGER.info("PipeConsensus-PipeName-{}: starting to receive tsFile seal", (Object)this.consensusPipeName);
        long startBorrowTsFileWriterNanos = System.nanoTime();
        PipeConsensusTsFileWriter tsFileWriter = this.pipeConsensusTsFileWriterPool.borrowCorrespondingWriter(req.getCommitId());
        long startPreCheckNanos = System.nanoTime();
        this.pipeConsensusReceiverMetrics.recordBorrowTsFileWriterTimer(startPreCheckNanos - startBorrowTsFileWriterNanos);
        File writingFile = tsFileWriter.getWritingFile();
        RandomAccessFile writingFileWriter = tsFileWriter.getWritingFileWriter();
        try {
            if (this.isWritingFileNonAvailable(tsFileWriter)) {
                TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_CONSENSUS_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file, because writing file %s is not available.", writingFile));
                LOGGER.warn(status.getMessage());
                TPipeConsensusTransferResp tPipeConsensusTransferResp = new TPipeConsensusTransferResp(status);
                return tPipeConsensusTransferResp;
            }
            TPipeConsensusTransferResp resp = this.checkFinalFileSeal(tsFileWriter, req.getFileName(), req.getFileLength());
            if (Objects.nonNull(resp)) {
                TPipeConsensusTransferResp tPipeConsensusTransferResp = resp;
                return tPipeConsensusTransferResp;
            }
            String fileAbsolutePath = writingFile.getAbsolutePath();
            writingFileWriter.getFD().sync();
            writingFileWriter.close();
            long endPreCheckNanos = System.nanoTime();
            this.pipeConsensusReceiverMetrics.recordTsFileSealPreCheckTimer(endPreCheckNanos - startPreCheckNanos);
            this.updateWritePointCountMetrics(req.getPointCount(), fileAbsolutePath);
            TSStatus status = this.loadFileToDataRegion(fileAbsolutePath, ProgressIndexType.deserializeFrom((ByteBuffer)ByteBuffer.wrap(req.getProgressIndex())));
            this.pipeConsensusReceiverMetrics.recordTsFileSealLoadTimer(System.nanoTime() - endPreCheckNanos);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.info("PipeConsensus-PipeName-{}: Seal file {} successfully.", (Object)this.consensusPipeName, (Object)fileAbsolutePath);
            } else {
                LOGGER.warn("PipeConsensus-PipeName-{}: Failed to seal file {}, because {}.", new Object[]{this.consensusPipeName, fileAbsolutePath, status.getMessage()});
            }
            TPipeConsensusTransferResp tPipeConsensusTransferResp = new TPipeConsensusTransferResp(status);
            return tPipeConsensusTransferResp;
        }
        catch (IOException e) {
            LOGGER.warn("PipeConsensus-PipeName-{}: Failed to seal file {} from req {}.", new Object[]{this.consensusPipeName, writingFile, req, e});
            TPipeConsensusTransferResp tPipeConsensusTransferResp = new TPipeConsensusTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_CONSENSUS_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s because %s", writingFile, e.getMessage())));
            return tPipeConsensusTransferResp;
        }
        catch (LoadFileException e) {
            LOGGER.warn("PipeConsensus-PipeName-{}: Failed to load file {} from req {}.", new Object[]{this.consensusPipeName, writingFile, req, e});
            TPipeConsensusTransferResp tPipeConsensusTransferResp = new TPipeConsensusTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.LOAD_FILE_ERROR, (String)String.format("Failed to seal file %s because %s", writingFile, e.getMessage())));
            return tPipeConsensusTransferResp;
        }
        finally {
            this.releaseTsFileWriter(tsFileWriter, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TPipeConsensusTransferResp handleTransferFileSealWithMods(PipeConsensusTsFileSealWithModReq req) {
        LOGGER.info("PipeConsensus-PipeName-{}: starting to receive tsFile seal with mods", (Object)this.consensusPipeName);
        long startBorrowTsFileWriterNanos = System.nanoTime();
        PipeConsensusTsFileWriter tsFileWriter = this.pipeConsensusTsFileWriterPool.borrowCorrespondingWriter(req.getCommitId());
        long startPreCheckNanos = System.nanoTime();
        this.pipeConsensusReceiverMetrics.recordBorrowTsFileWriterTimer(startPreCheckNanos - startBorrowTsFileWriterNanos);
        File writingFile = tsFileWriter.getWritingFile();
        RandomAccessFile writingFileWriter = tsFileWriter.getWritingFileWriter();
        File currentWritingDirPath = tsFileWriter.getLocalWritingDir();
        List files = req.getFileNames().stream().map(fileName -> new File(currentWritingDirPath, (String)fileName)).collect(Collectors.toList());
        try {
            if (this.isWritingFileNonAvailable(tsFileWriter)) {
                TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_CONSENSUS_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s, because writing file %s is not available.", req.getFileNames(), writingFile));
                LOGGER.warn(status.getMessage());
                TPipeConsensusTransferResp tPipeConsensusTransferResp = new TPipeConsensusTransferResp(status);
                return tPipeConsensusTransferResp;
            }
            for (int i = 0; i < req.getFileNames().size(); ++i) {
                TPipeConsensusTransferResp resp;
                TPipeConsensusTransferResp tPipeConsensusTransferResp = resp = i == req.getFileNames().size() - 1 ? this.checkFinalFileSeal(tsFileWriter, (String)req.getFileNames().get(i), (Long)req.getFileLengths().get(i)) : this.checkNonFinalFileSeal(tsFileWriter, (File)files.get(i), (String)req.getFileNames().get(i), (Long)req.getFileLengths().get(i));
                if (!Objects.nonNull(resp)) continue;
                TPipeConsensusTransferResp tPipeConsensusTransferResp2 = resp;
                return tPipeConsensusTransferResp2;
            }
            writingFileWriter.getFD().sync();
            writingFileWriter.close();
            List fileAbsolutePaths = files.stream().map(File::getAbsolutePath).collect(Collectors.toList());
            long endPreCheckNanos = System.nanoTime();
            this.pipeConsensusReceiverMetrics.recordTsFileSealPreCheckTimer(endPreCheckNanos - startPreCheckNanos);
            String tsFileAbsolutePath = (String)fileAbsolutePaths.get(1);
            this.updateWritePointCountMetrics((Long)req.getPointCounts().get(1), tsFileAbsolutePath);
            TSStatus status = this.loadFileToDataRegion(tsFileAbsolutePath, ProgressIndexType.deserializeFrom((ByteBuffer)ByteBuffer.wrap(req.getProgressIndex())));
            this.pipeConsensusReceiverMetrics.recordTsFileSealLoadTimer(System.nanoTime() - endPreCheckNanos);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.info("PipeConsensus-PipeName-{}: Seal file with mods {} successfully.", (Object)this.consensusPipeName, fileAbsolutePaths);
            } else {
                LOGGER.warn("PipeConsensus-PipeName-{}: Failed to seal file {}, status is {}.", new Object[]{this.consensusPipeName, fileAbsolutePaths, status});
            }
            TPipeConsensusTransferResp tPipeConsensusTransferResp = new TPipeConsensusTransferResp(status);
            return tPipeConsensusTransferResp;
        }
        catch (Exception e) {
            LOGGER.warn("PipeConsensus-PipeName-{}: Failed to seal file {} from req {}.", new Object[]{this.consensusPipeName, files, req, e});
            TPipeConsensusTransferResp tPipeConsensusTransferResp = new TPipeConsensusTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_CONSENSUS_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s because %s", writingFile, e.getMessage())));
            return tPipeConsensusTransferResp;
        }
        finally {
            this.releaseTsFileWriter(tsFileWriter, false);
            IoTDBReceiverAgent.cleanPipeReceiverDir((File)currentWritingDirPath);
        }
    }

    private TPipeConsensusTransferResp checkNonFinalFileSeal(PipeConsensusTsFileWriter tsFileWriter, File file, String fileName, long fileLength) throws IOException {
        RandomAccessFile writingFileWriter = tsFileWriter.getWritingFileWriter();
        if (!file.exists()) {
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_CONSENSUS_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s, the file does not exist.", fileName));
            LOGGER.warn("PipeConsensus-PipeName-{}: Failed to seal file {}, because the file does not exist.", (Object)this.consensusPipeName, (Object)fileName);
            return new TPipeConsensusTransferResp(status);
        }
        if (fileLength != file.length()) {
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_CONSENSUS_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s, because the length of file is not correct. The original file has length %s, but receiver file has length %s.", fileName, fileLength, writingFileWriter.length()));
            LOGGER.warn("PipeConsensus-PipeName-{}: Failed to seal file {} when check non final seal, because the length of file is not correct. The original file has length {}, but receiver file has length {}.", new Object[]{this.consensusPipeName, fileName, fileLength, writingFileWriter.length()});
            return new TPipeConsensusTransferResp(status);
        }
        return null;
    }

    private TSStatus loadFileToDataRegion(String filePath, ProgressIndex progressIndex) throws IOException, LoadFileException {
        DataRegion region = StorageEngine.getInstance().getDataRegion((DataRegionId)this.consensusGroupId);
        if (region != null) {
            TsFileResource resource = this.generateTsFileResource(filePath, progressIndex);
            region.loadNewTsFile(resource, true, false, true);
        } else {
            LOGGER.info("PipeConsensus-PipeName-{}: skip load tsfile-{} when sealing, because this region has been removed or migrated.", (Object)this.consensusPipeName, (Object)filePath);
        }
        return RpcUtils.SUCCESS_STATUS;
    }

    private void updateWritePointCountMetrics(long writePointCountGivenByReq, String tsFileAbsolutePath) {
        if (writePointCountGivenByReq >= 0L) {
            this.updateWritePointCountMetrics(writePointCountGivenByReq);
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PipeConsensus-PipeName-{}: The point count of TsFile {} is not given by sender, will read actual point count from TsFile.", (Object)this.consensusPipeName, (Object)tsFileAbsolutePath);
        }
        try (TsFileInsertionPointCounter counter = new TsFileInsertionPointCounter(new File(tsFileAbsolutePath), null);){
            this.updateWritePointCountMetrics(counter.count());
        }
        catch (IOException e) {
            LOGGER.warn("PipeConsensus-PipeName-{}: Failed to read TsFile when counting points: {}.", new Object[]{this.consensusPipeName, tsFileAbsolutePath, e});
        }
    }

    private void updateWritePointCountMetrics(long writePointCount) {
        Optional.ofNullable(StorageEngine.getInstance().getDataRegion((DataRegionId)this.consensusGroupId)).ifPresent(dataRegion -> dataRegion.getNonSystemDatabaseName().ifPresent(databaseName -> LoadTsFileManager.updateWritePointCountMetrics(dataRegion, databaseName, writePointCount, true)));
    }

    private TsFileResource generateTsFileResource(String filePath, ProgressIndex progressIndex) throws IOException {
        File tsFile = new File(filePath);
        TsFileResource tsFileResource = new TsFileResource(tsFile);
        try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFile.getAbsolutePath());){
            TsFileResourceUtils.updateTsFileResource(reader, tsFileResource);
        }
        tsFileResource.setStatus(TsFileResourceStatus.NORMAL);
        tsFileResource.setProgressIndex(progressIndex);
        tsFileResource.setGeneratedByPipeConsensus(true);
        tsFileResource.serialize();
        return tsFileResource;
    }

    private boolean isWritingFileNonAvailable(PipeConsensusTsFileWriter tsFileWriter) {
        boolean isWritingFileAvailable;
        File writingFile = tsFileWriter.getWritingFile();
        RandomAccessFile writingFileWriter = tsFileWriter.getWritingFileWriter();
        boolean bl = isWritingFileAvailable = writingFile != null && writingFile.exists() && writingFileWriter != null;
        if (!isWritingFileAvailable) {
            LOGGER.info("PipeConsensus-PipeName-{}: Writing file {} is not available. Writing file is null: {}, writing file exists: {}, writing file writer is null: {}.", new Object[]{this.consensusPipeName, writingFile, writingFile == null, writingFile != null && writingFile.exists(), writingFileWriter == null});
        }
        return !isWritingFileAvailable;
    }

    private TPipeConsensusTransferResp checkFinalFileSeal(PipeConsensusTsFileWriter tsFileWriter, String fileName, long fileLength) throws IOException {
        File writingFile = tsFileWriter.getWritingFile();
        RandomAccessFile writingFileWriter = tsFileWriter.getWritingFileWriter();
        if (!this.isFileExistedAndNameCorrect(tsFileWriter, fileName)) {
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_CONSENSUS_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s, because writing file is %s.", fileName, writingFile));
            LOGGER.warn("PipeConsensus-PipeName-{}: Failed to seal file {}, because writing file is {}.", new Object[]{this.consensusPipeName, fileName, writingFile});
            return new TPipeConsensusTransferResp(status);
        }
        if (this.isWritingFileOffsetNonCorrect(tsFileWriter, fileLength)) {
            TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_CONSENSUS_TRANSFER_FILE_ERROR, (String)String.format("Failed to seal file %s, because the length of file is not correct. The original file has length %s, but receiver file has length %s.", fileName, fileLength, writingFileWriter.length()));
            LOGGER.warn("PipeConsensus-PipeName-{}: Failed to seal file {} when check final seal file, because the length of file is not correct. The original file has length {}, but receiver file has length {}.", new Object[]{this.consensusPipeName, fileName, fileLength, writingFileWriter.length()});
            return new TPipeConsensusTransferResp(status);
        }
        return null;
    }

    private boolean isFileExistedAndNameCorrect(PipeConsensusTsFileWriter tsFileWriter, String fileName) {
        File writingFile = tsFileWriter.getWritingFile();
        return writingFile != null && writingFile.getName().equals(fileName);
    }

    private boolean isWritingFileOffsetNonCorrect(PipeConsensusTsFileWriter tsFileWriter, long offset) throws IOException {
        boolean offsetCorrect;
        File writingFile = tsFileWriter.getWritingFile();
        RandomAccessFile writingFileWriter = tsFileWriter.getWritingFileWriter();
        boolean bl = offsetCorrect = writingFileWriter.length() == offset;
        if (!offsetCorrect) {
            LOGGER.warn("PipeConsensus-PipeName-{}: Writing file {}'s offset is {}, but request sender's offset is {}.", new Object[]{this.consensusPipeName, writingFile.getPath(), writingFileWriter.length(), offset});
        }
        return !offsetCorrect;
    }

    private void updateWritingFileIfNeeded(PipeConsensusTsFileWriter tsFileWriter, String fileName, boolean isSingleFile) throws IOException {
        if (this.isFileExistedAndNameCorrect(tsFileWriter, fileName) && tsFileWriter.getWritingFileWriter() != null) {
            return;
        }
        LOGGER.info("PipeConsensus-PipeName-{}: Writing file {} is not existed or name is not correct, try to create it. Current writing file is {}.", new Object[]{this.consensusPipeName, fileName, tsFileWriter.getWritingFile() == null ? "null" : tsFileWriter.getWritingFile().getPath()});
        this.closeCurrentWritingFileWriter(tsFileWriter, !isSingleFile);
        if (tsFileWriter.getWritingFile() != null && isSingleFile) {
            this.deleteFileOrDirectoryIfExists(tsFileWriter.getWritingFile(), false, String.format("Update TsFileWriter-%s", tsFileWriter.index));
        }
        if (!tsFileWriter.getLocalWritingDir().exists()) {
            if (tsFileWriter.getLocalWritingDir().mkdirs()) {
                LOGGER.info("PipeConsensus-PipeName-{}: Receiver file dir {} was created.", (Object)this.consensusPipeName, (Object)tsFileWriter.getLocalWritingDir().getPath());
            } else {
                LOGGER.error("PipeConsensus-PipeName-{}: Failed to create receiver file dir {}.", (Object)this.consensusPipeName, (Object)tsFileWriter.getLocalWritingDir().getPath());
            }
        }
        tsFileWriter.setWritingFile(new File(tsFileWriter.getLocalWritingDir(), fileName));
        tsFileWriter.setWritingFileWriter(new RandomAccessFile(tsFileWriter.getWritingFile(), "rw"));
        LOGGER.info("PipeConsensus-PipeName-{}: Writing file {} was created. Ready to write file pieces.", (Object)this.consensusPipeName, (Object)tsFileWriter.getWritingFile().getPath());
    }

    private void initiateTsFileBufferFolder(List<String> receiverBaseDirsName) throws IOException {
        for (String receiverFileBaseDir : receiverBaseDirsName) {
            File newReceiverDir = new File(receiverFileBaseDir, this.consensusPipeName.toString());
            File systemDir = new File(IoTDBDescriptor.getInstance().getConfig().getSystemDir());
            if (!systemDir.exists()) {
                LOGGER.warn("PipeConsensus-PipeName-{}: Failed to create receiver file dir {}. Because parent system dir have been deleted due to system concurrently exit.", (Object)this.consensusPipeName, (Object)newReceiverDir.getPath());
                throw new IOException(String.format("PipeConsensus-PipeName-%s: Failed to create receiver file dir %s. Because parent system dir have been deleted due to system concurrently exit.", this.consensusPipeName, newReceiverDir.getPath()));
            }
            this.deleteFileOrDirectoryIfExists(newReceiverDir, true, "Initial Receiver: delete origin receive dir");
            if (!newReceiverDir.mkdirs()) {
                LOGGER.warn("PipeConsensus-PipeName-{}: Failed to create receiver file dir {}. May because authority or dir already exists etc.", (Object)this.consensusPipeName, (Object)newReceiverDir.getPath());
                throw new IOException(String.format("PipeConsensus-PipeName-%s: Failed to create receiver file dir %s. May because authority or dir already exists etc.", this.consensusPipeName, newReceiverDir.getPath()));
            }
            this.receiveDirs.add(newReceiverDir.getPath());
        }
    }

    private void clearAllReceiverBaseDir() {
        for (String receiverFileBaseDir : this.receiveDirs) {
            File receiverDir = new File(receiverFileBaseDir);
            this.deleteFileOrDirectoryIfExists(receiverDir, true, "Clear receive dir manually");
        }
    }

    public PipeConsensusRequestVersion getVersion() {
        return PipeConsensusRequestVersion.VERSION_1;
    }

    public synchronized void handleExit() {
        this.requestExecutor.tryClose();
        MetricService.getInstance().removeMetricSet((IMetricSet)this.pipeConsensusReceiverMetrics);
        if (this.tsFileWriterCheckerFuture != null) {
            this.tsFileWriterCheckerFuture.cancel(false);
            this.tsFileWriterCheckerFuture = null;
        }
        this.scheduledTsFileWriterCheckerPool.shutdownNow();
        try {
            if (!this.scheduledTsFileWriterCheckerPool.awaitTermination(30L, TimeUnit.SECONDS)) {
                LOGGER.warn("TsFileChecker did not terminate within {}s", (Object)30);
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("TsFileChecker Thread {} still doesn't exit after 30s", (Object)this.consensusPipeName);
            Thread.currentThread().interrupt();
        }
        this.requestExecutor.clear(false, true);
        LOGGER.info("Receiver-{} exit successfully.", (Object)this.consensusPipeName.toString());
    }

    public void closeExecutor() {
        this.requestExecutor.tryClose();
    }

    private void closeCurrentWritingFileWriter(PipeConsensusTsFileWriter tsFileWriter, boolean fsyncBeforeClose) {
        if (tsFileWriter.getWritingFileWriter() != null) {
            try {
                if (fsyncBeforeClose) {
                    tsFileWriter.getWritingFileWriter().getFD().sync();
                }
                tsFileWriter.getWritingFileWriter().close();
                LOGGER.info("PipeConsensus-PipeName-{}: Current writing file writer {} was closed.", (Object)this.consensusPipeName, (Object)(tsFileWriter.getWritingFile() == null ? "null" : tsFileWriter.getWritingFile().getPath()));
                tsFileWriter.setWritingFileWriter(null);
            }
            catch (IOException e) {
                LOGGER.warn("PipeConsensus-PipeName-{}: Failed to close current writing file writer {}, because {}.", new Object[]{this.consensusPipeName, tsFileWriter.getWritingFile() == null ? "null" : tsFileWriter.getWritingFile().getPath(), e.getMessage(), e});
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PipeConsensus-PipeName-{}: Current writing file writer is null. No need to close.", (Object)this.consensusPipeName.toString());
        }
    }

    private void deleteFileOrDirectoryIfExists(File file, boolean deleteDir, String reason) {
        if (file.exists()) {
            try {
                if (file.isDirectory()) {
                    if (deleteDir) {
                        RetryUtils.retryOnException(() -> {
                            FileUtils.deleteDirectory((File)file);
                            return null;
                        });
                    } else {
                        RetryUtils.retryOnException(() -> {
                            FileUtils.cleanDirectory((File)file);
                            return null;
                        });
                    }
                } else {
                    RetryUtils.retryOnException(() -> FileUtils.delete((File)file));
                }
                LOGGER.info("PipeConsensus-PipeName-{}: {} {} was deleted.", new Object[]{this.consensusPipeName, reason, file.getPath()});
            }
            catch (IOException e) {
                LOGGER.warn("PipeConsensus-PipeName-{}: {} Failed to delete {}, because {}.", new Object[]{this.consensusPipeName, reason, file.getPath(), e.getMessage(), e});
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PipeConsensus-PipeName-{}: {} {} is not existed. No need to delete.", new Object[]{this.consensusPipeName, reason, file.getPath()});
        }
    }

    private void releaseTsFileWriter(PipeConsensusTsFileWriter tsFileWriter, boolean fsyncBeforeClose) {
        if (tsFileWriter == null) {
            return;
        }
        this.closeCurrentWritingFileWriter(tsFileWriter, fsyncBeforeClose);
        this.deleteFileOrDirectoryIfExists(tsFileWriter.getLocalWritingDir(), false, String.format("Release TsFileWriter-%s", tsFileWriter.index));
        tsFileWriter.setWritingFile(null);
        try {
            tsFileWriter.returnSelf(this.consensusPipeName);
        }
        catch (IOException | DiskSpaceInsufficientException e) {
            LOGGER.warn("PipeConsensus-PipeName-{}: Failed to return tsFileWriter {}.", new Object[]{this.consensusPipeName, tsFileWriter, e});
        }
    }

    public int getReceiveBufferSize() {
        return this.requestExecutor.reqExecutionOrderBuffer.size();
    }

    public int getWALEventCount() {
        return this.requestExecutor.WALEventCount.get();
    }

    public int getTsFileEventCount() {
        return this.requestExecutor.tsFileEventCount.get();
    }

    public String getConsensusGroupIdStr() {
        return this.consensusGroupId.toString();
    }

    private class PipeConsensusTsFileWriter {
        private final ConsensusPipeName consensusPipeName;
        private final int index;
        private File localWritingDir;
        private File writingFile;
        private RandomAccessFile writingFileWriter;
        private volatile boolean isUsed = false;
        private volatile TCommitId commitIdOfCorrespondingHolderEvent;
        private long lastUsedTs;

        public PipeConsensusTsFileWriter(int index, ConsensusPipeName consensusPipeName) {
            this.index = index;
            this.consensusPipeName = consensusPipeName;
        }

        public void rollToNextWritingPath() throws IOException, DiskSpaceInsufficientException {
            if (PipeConsensusReceiver.this.folderManager == null) {
                throw new IOException(String.format("PipeConsensus-PipeName-%s: Failed to create tsFileWriter-%d receiver file dir", this.consensusPipeName, this.index));
            }
            this.localWritingDir = PipeConsensusReceiver.this.folderManager.getNextWithRetry(receiverBasePath -> {
                if (receiverBasePath == null) {
                    LOGGER.warn("PipeConsensus-PipeName-{}: Failed to get base directory", (Object)this.consensusPipeName);
                    return null;
                }
                File writingDir = new File(receiverBasePath + File.separator + this.index);
                PipeConsensusReceiver.this.deleteFileOrDirectoryIfExists(writingDir, true, String.format("TsFileWriter-%s roll to new dir and delete last writing dir", this.index));
                if (writingDir.mkdirs()) {
                    LOGGER.info("PipeConsensus-PipeName-{}: tsfileWriter-{} roll to writing path {}", new Object[]{this.consensusPipeName, this.index, writingDir.getPath()});
                    return writingDir;
                }
                LOGGER.warn("PipeConsensus-PipeName-{}: Failed to create receiver tsFileWriter-{} file dir {}", new Object[]{this.consensusPipeName, this.index, writingDir.getPath()});
                return null;
            });
            if (this.localWritingDir == null) {
                throw new IOException(String.format("PipeConsensus-PipeName-%s: Failed to create tsFileWriter-%d receiver file dir", this.consensusPipeName, this.index));
            }
        }

        public File getLocalWritingDir() {
            return this.localWritingDir;
        }

        public File getWritingFile() {
            return this.writingFile;
        }

        public void setWritingFile(File writingFile) {
            this.writingFile = writingFile;
            if (writingFile == null) {
                LOGGER.info("PipeConsensus-{}: TsFileWriter-{} set null writing file", (Object)this.consensusPipeName.toString(), (Object)this.index);
            }
        }

        public RandomAccessFile getWritingFileWriter() {
            return this.writingFileWriter;
        }

        public void setWritingFileWriter(RandomAccessFile writingFileWriter) throws IOException {
            this.writingFileWriter = writingFileWriter;
            if (writingFileWriter == null) {
                LOGGER.info("PipeConsensus-{}: TsFileWriter-{} set null writing file writer", (Object)this.consensusPipeName.toString(), (Object)this.index);
            } else {
                this.writingFileWriter.seek(this.writingFileWriter.length());
            }
        }

        public TCommitId getCommitIdOfCorrespondingHolderEvent() {
            return this.commitIdOfCorrespondingHolderEvent;
        }

        public void setCommitIdOfCorrespondingHolderEvent(TCommitId commitIdOfCorrespondingHolderEvent) {
            this.commitIdOfCorrespondingHolderEvent = commitIdOfCorrespondingHolderEvent;
        }

        public boolean isUsed() {
            return this.isUsed;
        }

        public void setUsed(boolean used) {
            this.isUsed = used;
        }

        public PipeConsensusTsFileWriter refreshLastUsedTs() {
            if (this.isUsed) {
                this.lastUsedTs = System.currentTimeMillis();
            }
            return this;
        }

        public void returnSelf(ConsensusPipeName consensusPipeName) throws DiskSpaceInsufficientException, IOException {
            if (PipeConsensusReceiver.this.receiveDirs.size() > 1) {
                this.rollToNextWritingPath();
            }
            this.commitIdOfCorrespondingHolderEvent = null;
            this.isUsed = false;
            LOGGER.info("PipeConsensus-PipeName-{}: tsFileWriter-{} returned self", (Object)consensusPipeName.toString(), (Object)this.index);
        }
    }

    private class PipeConsensusTsFileWriterPool {
        private final Lock lock = new ReentrantLock();
        private final List<PipeConsensusTsFileWriter> pipeConsensusTsFileWriterPool = new ArrayList<PipeConsensusTsFileWriter>();
        private final ConsensusPipeName consensusPipeName;

        public PipeConsensusTsFileWriterPool(ConsensusPipeName consensusPipeName) throws DiskSpaceInsufficientException, IOException {
            this.consensusPipeName = consensusPipeName;
            for (int i = 0; i < IOTDB_CONFIG.getIotConsensusV2PipelineSize(); ++i) {
                PipeConsensusTsFileWriter tsFileWriter = new PipeConsensusTsFileWriter(i, consensusPipeName);
                tsFileWriter.rollToNextWritingPath();
                this.pipeConsensusTsFileWriterPool.add(tsFileWriter);
            }
            PipeConsensusReceiver.this.tsFileWriterCheckerFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)PipeConsensusReceiver.this.scheduledTsFileWriterCheckerPool, this::checkZombieTsFileWriter, (long)0L, (long)IOTDB_CONFIG.getTsFileWriterCheckInterval(), (TimeUnit)TimeUnit.MILLISECONDS);
            LOGGER.info("Register {} with interval in seconds {} successfully.", (Object)ThreadName.PIPE_CONSENSUS_TSFILE_WRITER_CHECKER.getName(), (Object)IOTDB_CONFIG.getTsFileWriterCheckInterval());
        }

        public PipeConsensusTsFileWriter tryToFindCorrespondingWriter(TCommitId commitId) {
            Optional<PipeConsensusTsFileWriter> tsFileWriter = this.pipeConsensusTsFileWriterPool.stream().filter(item -> item.isUsed() && Objects.equals(commitId, item.getCommitIdOfCorrespondingHolderEvent())).findFirst();
            return tsFileWriter.orElse(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PipeConsensusTsFileWriter borrowCorrespondingWriter(TCommitId commitId) {
            Optional<PipeConsensusTsFileWriter> tsFileWriter = this.pipeConsensusTsFileWriterPool.stream().filter(item -> item.isUsed() && Objects.equals(commitId, item.getCommitIdOfCorrespondingHolderEvent())).findFirst();
            if (!tsFileWriter.isPresent()) {
                this.lock.lock();
                try {
                    while (!tsFileWriter.isPresent()) {
                        tsFileWriter = this.pipeConsensusTsFileWriterPool.stream().filter(item -> !item.isUsed()).findFirst();
                        Thread.sleep(500L);
                    }
                    tsFileWriter.get().setUsed(true);
                    tsFileWriter.get().setCommitIdOfCorrespondingHolderEvent(commitId);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOGGER.warn("PipeConsensus{}: receiver thread get interrupted when waiting for borrowing tsFileWriter.", (Object)this.consensusPipeName);
                }
                finally {
                    this.lock.unlock();
                }
            }
            return tsFileWriter.get().refreshLastUsedTs();
        }

        private void checkZombieTsFileWriter() {
            this.pipeConsensusTsFileWriterPool.stream().filter(PipeConsensusTsFileWriter::isUsed).forEach(writer -> {
                if (System.currentTimeMillis() - ((PipeConsensusTsFileWriter)writer).lastUsedTs >= IOTDB_CONFIG.getTsFileWriterZombieThreshold()) {
                    PipeConsensusReceiver.this.releaseTsFileWriter(writer, false);
                    LOGGER.info("PipeConsensus-PipeName-{}: tsfile writer-{} is cleaned up because no new requests were received for too long.", (Object)this.consensusPipeName, (Object)((PipeConsensusTsFileWriter)writer).index);
                }
            });
        }

        public void releaseAllWriters(ConsensusPipeName consensusPipeName) {
            this.pipeConsensusTsFileWriterPool.forEach(tsFileWriter -> {
                long currentTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - currentTime < 5000L && tsFileWriter.isUsed()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOGGER.warn("PipeConsensus-PipeName-{}: receiver thread get interrupted when exiting.", (Object)consensusPipeName.toString());
                        break;
                    }
                }
                PipeConsensusReceiver.this.releaseTsFileWriter(tsFileWriter, false);
            });
        }
    }

    private class RequestExecutor {
        private static final String MSG_NODE_RESTART_INDEX_STALE = "sender dn restarts before this event was sent here";
        private static final String MSG_PIPE_RESTART_INDEX_STALE = "pipe task restarts before this event was sent here";
        private static final String MSG_STALE_REPLICATE_INDEX = "replicate index is out dated";
        private final TreeSet<RequestMeta> reqExecutionOrderBuffer;
        private final Lock lock;
        private final Condition condition;
        private final PipeConsensusReceiverMetrics metric;
        private final PipeConsensusTsFileWriterPool tsFileWriterPool;
        private final AtomicInteger WALEventCount = new AtomicInteger(0);
        private final AtomicInteger tsFileEventCount = new AtomicInteger(0);
        private volatile long onSyncedReplicateIndex = 0L;
        private volatile int connectorRebootTimes = 0;
        private volatile int pipeTaskRestartTimes = 0;

        public RequestExecutor(PipeConsensusReceiverMetrics metric, PipeConsensusTsFileWriterPool tsFileWriterPool) {
            this.reqExecutionOrderBuffer = new TreeSet<RequestMeta>(Comparator.comparingInt(RequestMeta::getDataNodeRebootTimes).thenComparingInt(RequestMeta::getPipeTaskRestartTimes).thenComparingLong(RequestMeta::getReplicateIndex));
            this.lock = new ReentrantLock();
            this.condition = this.lock.newCondition();
            this.metric = metric;
            this.tsFileWriterPool = tsFileWriterPool;
        }

        private TPipeConsensusTransferResp preCheck(TCommitId tCommitId) {
            if (tCommitId.getDataNodeRebootTimes() < this.connectorRebootTimes) {
                return this.deprecatedResp(MSG_NODE_RESTART_INDEX_STALE, tCommitId);
            }
            if (tCommitId.getDataNodeRebootTimes() == this.connectorRebootTimes && tCommitId.getPipeTaskRestartTimes() < this.pipeTaskRestartTimes) {
                return this.deprecatedResp(MSG_PIPE_RESTART_INDEX_STALE, tCommitId);
            }
            if (tCommitId.getDataNodeRebootTimes() == this.connectorRebootTimes && tCommitId.getPipeTaskRestartTimes() == this.pipeTaskRestartTimes && tCommitId.getReplicateIndex() < this.onSyncedReplicateIndex + 1L) {
                return this.deprecatedResp(MSG_STALE_REPLICATE_INDEX, tCommitId);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TPipeConsensusTransferResp onRequest(TPipeConsensusTransferReq req, boolean isTransferTsFilePiece, boolean isTransferTsFileSeal) {
            long startAcquireLockNanos = System.nanoTime();
            this.lock.lock();
            try {
                if (PipeConsensusReceiver.this.isClosed.get()) {
                    TPipeConsensusTransferResp tPipeConsensusTransferResp = PipeConsensusReceiverAgent.closedResp(PipeConsensusReceiver.this.consensusPipeName.toString(), req.getCommitId());
                    return tPipeConsensusTransferResp;
                }
                long startDispatchNanos = System.nanoTime();
                this.metric.recordAcquireExecutorLockTimer(startDispatchNanos - startAcquireLockNanos);
                TCommitId tCommitId = req.getCommitId();
                RequestMeta requestMeta = new RequestMeta(tCommitId);
                TPipeConsensusTransferResp preCheckRes = this.preCheck(tCommitId);
                if (preCheckRes != null) {
                    TPipeConsensusTransferResp tPipeConsensusTransferResp = preCheckRes;
                    return tPipeConsensusTransferResp;
                }
                LOGGER.info("PipeConsensus-PipeName-{}: start to receive no.{} event", (Object)PipeConsensusReceiver.this.consensusPipeName, (Object)tCommitId);
                if (tCommitId.getDataNodeRebootTimes() > this.connectorRebootTimes) {
                    this.resetWithNewestRebootTime(tCommitId.getDataNodeRebootTimes());
                }
                if (tCommitId.getPipeTaskRestartTimes() > this.pipeTaskRestartTimes) {
                    this.resetWithNewestRestartTime(tCommitId.getPipeTaskRestartTimes());
                }
                if (isTransferTsFilePiece && !this.reqExecutionOrderBuffer.contains(requestMeta)) {
                    this.tsFileEventCount.incrementAndGet();
                }
                if (!isTransferTsFileSeal && !isTransferTsFilePiece) {
                    this.WALEventCount.incrementAndGet();
                }
                this.reqExecutionOrderBuffer.add(requestMeta);
                if (isTransferTsFilePiece) {
                    long startApplyNanos = System.nanoTime();
                    this.metric.recordDispatchWaitingTimer(startApplyNanos - startDispatchNanos);
                    requestMeta.setStartApplyNanos(startApplyNanos);
                    TPipeConsensusTransferResp tPipeConsensusTransferResp = null;
                    return tPipeConsensusTransferResp;
                }
                if (this.reqExecutionOrderBuffer.size() >= IOTDB_CONFIG.getIotConsensusV2PipelineSize() && !this.reqExecutionOrderBuffer.first().equals(requestMeta)) {
                    this.condition.signalAll();
                }
                while (true) {
                    boolean timeout;
                    if (this.reqExecutionOrderBuffer.first().equals(requestMeta) && tCommitId.getReplicateIndex() == this.onSyncedReplicateIndex + 1L) {
                        long startApplyNanos = System.nanoTime();
                        this.metric.recordDispatchWaitingTimer(startApplyNanos - startDispatchNanos);
                        requestMeta.setStartApplyNanos(startApplyNanos);
                        TPipeConsensusTransferResp resp = PipeConsensusReceiver.this.loadEvent(req);
                        if (resp != null && resp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            this.onSuccess(tCommitId, isTransferTsFileSeal);
                        }
                        TPipeConsensusTransferResp tPipeConsensusTransferResp = resp;
                        return tPipeConsensusTransferResp;
                    }
                    if (this.reqExecutionOrderBuffer.size() >= IOTDB_CONFIG.getIotConsensusV2PipelineSize() && this.reqExecutionOrderBuffer.first().equals(requestMeta)) {
                        LOGGER.info("PipeConsensus-PipeName-{}: no.{} event get executed because receiver buffer's len >= pipeline, current receiver syncIndex {}, current buffer len {}", new Object[]{PipeConsensusReceiver.this.consensusPipeName, tCommitId, this.onSyncedReplicateIndex, this.reqExecutionOrderBuffer.size()});
                        long startApplyNanos = System.nanoTime();
                        this.metric.recordDispatchWaitingTimer(startApplyNanos - startDispatchNanos);
                        requestMeta.setStartApplyNanos(startApplyNanos);
                        TPipeConsensusTransferResp resp = PipeConsensusReceiver.this.loadEvent(req);
                        if (resp != null && resp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            this.onSuccess(tCommitId, isTransferTsFileSeal);
                        }
                        TPipeConsensusTransferResp tPipeConsensusTransferResp = resp;
                        return tPipeConsensusTransferResp;
                    }
                    boolean bl = timeout = !this.condition.await(PIPE_CONSENSUS_RECEIVER_MAX_WAITING_TIME_IN_MS, TimeUnit.MILLISECONDS);
                    if (PipeConsensusReceiver.this.isClosed.get()) {
                        TPipeConsensusTransferResp tPipeConsensusTransferResp = PipeConsensusReceiverAgent.closedResp(PipeConsensusReceiver.this.consensusPipeName.toString(), req.getCommitId());
                        return tPipeConsensusTransferResp;
                    }
                    if (!this.reqExecutionOrderBuffer.contains(requestMeta)) {
                        TPipeConsensusTransferResp tPipeConsensusTransferResp = this.deprecatedResp(String.format("%s or %s", MSG_NODE_RESTART_INDEX_STALE, MSG_PIPE_RESTART_INDEX_STALE), tCommitId);
                        return tPipeConsensusTransferResp;
                    }
                    if (!timeout || this.reqExecutionOrderBuffer.first() == null) continue;
                    if (this.reqExecutionOrderBuffer.first().equals(requestMeta)) {
                        LOGGER.info("PipeConsensus-PipeName-{}: no.{} event get executed after awaiting timeout, current receiver syncIndex: {}", new Object[]{PipeConsensusReceiver.this.consensusPipeName, tCommitId, this.onSyncedReplicateIndex});
                        long startApplyNanos = System.nanoTime();
                        this.metric.recordDispatchWaitingTimer(startApplyNanos - startDispatchNanos);
                        requestMeta.setStartApplyNanos(startApplyNanos);
                        TPipeConsensusTransferResp resp = PipeConsensusReceiver.this.loadEvent(req);
                        if (resp != null && resp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            this.onSuccess(tCommitId, isTransferTsFileSeal);
                        }
                        TPipeConsensusTransferResp tPipeConsensusTransferResp = resp;
                        return tPipeConsensusTransferResp;
                    }
                    TSStatus status = new TSStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_CONSENSUS_WAIT_ORDER_TIMEOUT, (String)"Waiting for the previous event times out, returns an error to let the sender retry and continue scheduling."));
                    LOGGER.info("PipeConsensus-{}: Waiting for the previous event times out, current peek {}, current id {}", new Object[]{PipeConsensusReceiver.this.consensusPipeName, this.reqExecutionOrderBuffer.first().commitId, tCommitId});
                    TPipeConsensusTransferResp tPipeConsensusTransferResp = new TPipeConsensusTransferResp(status);
                    return tPipeConsensusTransferResp;
                }
            }
            finally {
                this.condition.signalAll();
                this.lock.unlock();
            }
        }

        private void resetWithNewestRebootTime(int connectorRebootTimes) {
            LOGGER.info("PipeConsensus-PipeName-{}: receiver detected an newer rebootTimes, which indicates the leader has rebooted. receiver will reset all its data.", (Object)PipeConsensusReceiver.this.consensusPipeName);
            this.clear(true, false);
            this.connectorRebootTimes = connectorRebootTimes;
            this.pipeTaskRestartTimes = 0;
        }

        private void resetWithNewestRestartTime(int pipeTaskRestartTimes) {
            LOGGER.info("PipeConsensus-PipeName-{}: receiver detected an newer pipeTaskRestartTimes, which indicates the pipe task has restarted. receiver will reset all its data.", (Object)PipeConsensusReceiver.this.consensusPipeName);
            this.clear(false, false);
            this.pipeTaskRestartTimes = pipeTaskRestartTimes;
        }

        private void onSuccess(TCommitId commitId, boolean isTransferTsFileSeal) {
            LOGGER.info("PipeConsensus-PipeName-{}: process no.{} event successfully!", (Object)PipeConsensusReceiver.this.consensusPipeName, (Object)commitId);
            RequestMeta curMeta = this.reqExecutionOrderBuffer.pollFirst();
            this.onSyncedReplicateIndex = commitId.getReplicateIndex();
            if (isTransferTsFileSeal) {
                this.tsFileEventCount.decrementAndGet();
                this.metric.recordReceiveTsFileTimer(System.nanoTime() - curMeta.getStartApplyNanos());
            } else {
                this.WALEventCount.decrementAndGet();
                this.metric.recordReceiveWALTimer(System.nanoTime() - curMeta.getStartApplyNanos());
            }
        }

        private void clear(boolean resetSyncIndex, boolean cleanBaseDir) {
            PipeConsensusReceiver.this.tsFilePieceReadWriteLock.writeLock().lock();
            try {
                this.reqExecutionOrderBuffer.clear();
                this.tsFileWriterPool.releaseAllWriters(PipeConsensusReceiver.this.consensusPipeName);
                this.tsFileEventCount.set(0);
                this.WALEventCount.set(0);
                if (resetSyncIndex) {
                    this.onSyncedReplicateIndex = 0L;
                }
                if (cleanBaseDir) {
                    PipeConsensusReceiver.this.clearAllReceiverBaseDir();
                }
            }
            finally {
                PipeConsensusReceiver.this.tsFilePieceReadWriteLock.writeLock().unlock();
            }
        }

        private void tryClose() {
            this.lock.lock();
            try {
                PipeConsensusReceiver.this.isClosed.set(true);
            }
            finally {
                this.condition.signalAll();
                this.lock.unlock();
            }
        }

        private TPipeConsensusTransferResp deprecatedResp(String msg, TCommitId tCommitId) {
            TSStatus status = new TSStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_CONSENSUS_DEPRECATED_REQUEST, (String)String.format("PipeConsensus receiver received a deprecated request, which may because %s. Consider to discard it.", msg)));
            LOGGER.info("PipeConsensus-PipeName-{}: received a deprecated request-{}, which may because {}. ", new Object[]{PipeConsensusReceiver.this.consensusPipeName, tCommitId, msg});
            return new TPipeConsensusTransferResp(status);
        }
    }

    private static class RequestMeta {
        private final TCommitId commitId;
        private long startApplyNanos = 0L;

        public RequestMeta(TCommitId commitId) {
            this.commitId = commitId;
        }

        public int getDataNodeRebootTimes() {
            return this.commitId.getDataNodeRebootTimes();
        }

        public int getPipeTaskRestartTimes() {
            return this.commitId.getPipeTaskRestartTimes();
        }

        public long getReplicateIndex() {
            return this.commitId.getReplicateIndex();
        }

        public void setStartApplyNanos(long startApplyNanos) {
            if (this.startApplyNanos == 0L) {
                this.startApplyNanos = startApplyNanos;
            }
        }

        public long getStartApplyNanos() {
            if (this.startApplyNanos == 0L) {
                return System.nanoTime();
            }
            return this.startApplyNanos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestMeta that = (RequestMeta)o;
            return this.commitId.equals(that.commitId);
        }

        public int hashCode() {
            return Objects.hash(this.commitId);
        }
    }
}

