/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.model.Quota;

public class QuotaRatio {
    private final Quota<QuotaSizeLimit, QuotaSizeUsage> quotaSize;
    private final Quota<QuotaCountLimit, QuotaCountUsage> quotaCount;

    public static QuotaRatio from(Quota<QuotaSizeLimit, QuotaSizeUsage> quotaSize, Quota<QuotaCountLimit, QuotaCountUsage> quotaCount) {
        return new QuotaRatio(quotaSize, quotaCount);
    }

    private QuotaRatio(Quota<QuotaSizeLimit, QuotaSizeUsage> quotaSize, Quota<QuotaCountLimit, QuotaCountUsage> quotaCount) {
        Preconditions.checkNotNull(quotaSize, "'quotaSize' is mandatory");
        Preconditions.checkNotNull(quotaCount, "'quotaCount' is mandatory");
        this.quotaSize = quotaSize;
        this.quotaCount = quotaCount;
    }

    public Quota<QuotaSizeLimit, QuotaSizeUsage> getQuotaSize() {
        return this.quotaSize;
    }

    public Quota<QuotaCountLimit, QuotaCountUsage> getQuotaCount() {
        return this.quotaCount;
    }

    public double max() {
        return Math.max(this.quotaSize.getRatio(), this.quotaCount.getRatio());
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaRatio) {
            QuotaRatio quotaRatio = (QuotaRatio)o;
            return Objects.equals(this.quotaSize, quotaRatio.quotaSize) && Objects.equals(this.quotaCount, quotaRatio.quotaCount);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.quotaSize, this.quotaCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("quotaSize", this.quotaSize).add("quotaCount", this.quotaCount).toString();
    }
}

