# JSON Meta Application Protocol (JMAP) Specification

This repo contains the specifications for JMAP. 

JMAP is a modern standard for email clients to connect to mail stores. It therefore primarily replaces IMAP + SMTP submission. It does not replace MTA-to-MTA SMTP transmission. JMAP was built by the community, and continues to improve via the [IETF standardization process](https://datatracker.ietf.org/wg/jmap/about/). Upcoming work includes adding contacts and calendars (replacing CardDAV/CalDAV).

The pretty HTML version of the spec along with more JMAP info and resources can be found at http://jmap.io.

## Get involved

JMAP is being developed within the IETF by the [JMAP Working Group](https://datatracker.ietf.org/wg/jmap/about/).

You can join the mailing list at https://www.ietf.org/mailman/listinfo/jmap. Feedback is welcome: send your thoughts or comments on anything that is imprecise, incomplete, or could simply be done better in another way. Discussion is preferred prior to pull requests, except in the case of minor typos etc.

## Contributions

This repository relates to activities in the Internet Engineering Task
Force (IETF). All material in this repository is considered Contributions
to the IETF Standards Process, as defined in the intellectual property
policies of IETF currently designated as [BCP 78](https://www.rfc-editor.org/info/bcp78), [BCP 79](https://www.rfc-editor.org/info/bcp79) and the [IETF Trust Legal Provisions (TLP) Relating to IETF Documents](http://trustee.ietf.org/trust-legal-provisions.html).

Any edit, commit, pull request, issue, comment or other change made to this
repository constitutes Contributions to the [IETF Standards Process](https://www.ietf.org/).

You agree to comply with all applicable IETF policies and procedures,
including, BCP 78, 79, the TLP, and the TLP rules regarding code
components (e.g. being subject to a Simplified BSD License) in
Contributions.
