/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing.eventstore.cassandra;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.Event$;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.EventStoreFailedException;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.eventsourcing.eventstore.cassandra.EventStoreDao;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scala.publisher.package$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005A4Aa\u0002\u0005\u0001+!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u00033\u0001\u0011\u00053\u0007C\u0003U\u0001\u0011%Q\u000bC\u0003c\u0001\u0011\u00053\rC\u0003n\u0001\u0011\u0005cNA\nDCN\u001c\u0018M\u001c3sC\u00163XM\u001c;Ti>\u0014XM\u0003\u0002\n\u0015\u0005I1-Y:tC:$'/\u0019\u0006\u0003\u00171\t!\"\u001a<f]R\u001cHo\u001c:f\u0015\tia\"A\u0007fm\u0016tGo]8ve\u000eLgn\u001a\u0006\u0003\u001fA\tQA[1nKNT!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011c\u0001\u0001\u00179A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\u0004\"!\b\u0010\u000e\u0003)I!a\b\u0006\u0003\u0015\u00153XM\u001c;Ti>\u0014X-A\u0007fm\u0016tGo\u0015;pe\u0016$\u0015m\u001c\t\u0003E\rj\u0011\u0001C\u0005\u0003I!\u0011Q\"\u0012<f]R\u001cFo\u001c:f\t\u0006|\u0017A\u0002\u001fj]&$h\b\u0006\u0002(QA\u0011!\u0005\u0001\u0005\u0006A\t\u0001\r!\t\u0015\u0003\u0005)\u0002\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\r%t'.Z2u\u0015\u0005y\u0013!\u00026bm\u0006D\u0018BA\u0019-\u0005\u0019IeN[3di\u0006I\u0011\r\u001d9f]\u0012\fE\u000e\u001c\u000b\u0003i\t\u00032!\u000e\u001d;\u001b\u00051$BA\u001c\u0013\u0003=\u0011X-Y2uSZ,7\u000f\u001e:fC6\u001c\u0018BA\u001d7\u0005%\u0001VO\u00197jg\",'\u000f\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005!A.\u00198h\u0015\u0005y\u0014\u0001\u00026bm\u0006L!!\u0011\u001f\u0003\tY{\u0017\u000e\u001a\u0005\u0006\u0007\u000e\u0001\r\u0001R\u0001\u0007KZ,g\u000e^:\u0011\u0007\u0015k\u0005K\u0004\u0002G\u0017:\u0011qIS\u0007\u0002\u0011*\u0011\u0011\nF\u0001\u0007yI|w\u000e\u001e \n\u0003eI!\u0001\u0014\r\u0002\u000fA\f7m[1hK&\u0011aj\u0014\u0002\t\u0013R,'/\u00192mK*\u0011A\n\u0007\t\u0003#Jk\u0011\u0001D\u0005\u0003'2\u0011Q!\u0012<f]R\f1\u0002Z8BaB,g\u000eZ!mYR\u0011a+\u0019\t\u0004/~ST\"\u0001-\u000b\u0005eS\u0016!\u00039vE2L7\u000f[3s\u0015\tI2L\u0003\u0002];\u0006!1m\u001c:f\u0015\u0005q\u0016a\u0002:fC\u000e$xN]\u0005\u0003Ab\u0013QaU'p]>DQa\u0011\u0003A\u0002\u0011\u000bAcZ3u\u000bZ,g\u000e^:PM\u0006;wM]3hCR,GC\u00013i!\r9v,\u001a\t\u0003;\u0019L!a\u001a\u0006\u0003\u000f!K7\u000f^8ss\")\u0011.\u0002a\u0001U\u0006Y\u0011mZ4sK\u001e\fG/Z%e!\t\t6.\u0003\u0002m\u0019\tY\u0011iZ4sK\u001e\fG/Z%e\u0003\u0019\u0011X-\\8wKR\u0011Ag\u001c\u0005\u0006S\u001a\u0001\rA\u001b")
public class CassandraEventStore
implements EventStore {
    private final EventStoreDao eventStoreDao;

    public Publisher<Void> append(Event event) {
        return EventStore.append$((EventStore)this, (Event)event);
    }

    public Publisher<Void> appendAll(Seq<Event> events) {
        return EventStore.appendAll$((EventStore)this, events);
    }

    public Publisher<Void> appendAll(Event ... events) {
        return EventStore.appendAll$((EventStore)this, (Event[])events);
    }

    public Publisher<Void> appendAll(Iterable<Event> events) {
        if (events.nonEmpty()) {
            return this.doAppendAll(events);
        }
        return SMono$.MODULE$.empty();
    }

    private SMono<Void> doAppendAll(Iterable<Event> events) {
        Preconditions.checkArgument((boolean)Event$.MODULE$.belongsToSameAggregate(events));
        Option snapshotId = ((IterableOps)((IterableOps)events.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isASnapshot()))).map((Function1 & Serializable)x$2 -> x$2.eventId())).headOption();
        return this.eventStoreDao.appendAll(events, (Option<EventId>)snapshotId).filter((Function1 & Serializable)success -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)success))).single().onErrorMap((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof NoSuchElementException) {
                    return (B1)new EventStoreFailedException("Concurrent update to the EventStore detected");
                }
                return (B1)A1;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof NoSuchElementException) {
                    return true;
                }
                return true;
            }
        }).then(SMono$.MODULE$.empty());
    }

    public SMono<History> getEventsOfAggregate(AggregateId aggregateId) {
        return this.eventStoreDao.getSnapshot(aggregateId).flatMap((Function1 & Serializable)snapshotId -> $this.eventStoreDao.getEventsOfAggregate(aggregateId, (EventId)snapshotId)).switchIfEmpty(this.eventStoreDao.getEventsOfAggregate(aggregateId));
    }

    public Publisher<Void> remove(AggregateId aggregateId) {
        return package$.MODULE$.publisherUnit2PublisherVoid(this.eventStoreDao.delete(aggregateId));
    }

    @Inject
    public CassandraEventStore(EventStoreDao eventStoreDao) {
        this.eventStoreDao = eventStoreDao;
        EventStore.$init$((EventStore)this);
    }
}

