/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogReader;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public abstract class AccessLogMessage
extends LogMessage {
    private static final long serialVersionUID = 111497572975341652L;
    @Nullable
    private final Long connectionID;
    @Nullable
    private final String instanceName;
    @Nullable
    private final String productName = this.getNamedValue("product");
    @Nullable
    private final String startupID;

    protected AccessLogMessage(@NotNull LogMessage m) {
        super(m);
        this.instanceName = this.getNamedValue("instanceName");
        this.startupID = this.getNamedValue("startupID");
        this.connectionID = this.getNamedValueAsLong("conn");
    }

    @NotNull
    public static AccessLogMessage parse(@NotNull String s) throws LogException {
        return AccessLogReader.parse(s);
    }

    @Nullable
    public final String getProductName() {
        return this.productName;
    }

    @Nullable
    public final String getInstanceName() {
        return this.instanceName;
    }

    @Nullable
    public final String getStartupID() {
        return this.startupID;
    }

    @Nullable
    public final Long getConnectionID() {
        return this.connectionID;
    }

    @NotNull
    public abstract AccessLogMessageType getMessageType();
}

