/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailrepository.guice;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryFactory;
import org.apache.james.mailrepository.api.MailRepositoryLoader;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.api.MailRepositoryUrl;

public class MultiBoundGuiceRepositoryLoader
implements MailRepositoryLoader {
    private final Map<String, Function<MailRepositoryUrl, MailRepository>> factoriesByType;

    @Inject
    private MultiBoundGuiceRepositoryLoader(Set<MailRepositoryFactory> factories) {
        this.factoriesByType = factories.stream().collect(Collectors.toMap(factory -> factory.mailRepositoryClass().getName(), it -> arg_0 -> ((MailRepositoryFactory)it).create(arg_0)));
    }

    public MailRepository load(String fullyQualifiedClassName, MailRepositoryUrl url) throws MailRepositoryStore.MailRepositoryStoreException {
        return Optional.ofNullable(this.factoriesByType.get(fullyQualifiedClassName)).map(factory -> (MailRepository)factory.apply(url)).orElseThrow(() -> new MailRepositoryStore.MailRepositoryStoreException("no factory for " + fullyQualifiedClassName));
    }
}

