/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ClearMailQueueTask
implements Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClearMailQueueTask.class);
    public static final TaskType TYPE = TaskType.of((String)"clear-mail-queue");
    private final MailQueueName queueName;
    private final MailQueueFactory factory;
    private Optional<Long> initialCount;
    private Optional<ManageableMailQueue> queue;
    private Optional<TaskExecutionDetails.AdditionalInformation> lastAdditionalInformation;

    public ClearMailQueueTask(MailQueueName queueName, MailQueueFactory factory) {
        this.queueName = queueName;
        this.factory = factory;
        this.initialCount = Optional.empty();
        this.queue = Optional.empty();
        this.lastAdditionalInformation = Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task.Result run() {
        try (ManageableMailQueue queue = this.factory.create(this.queueName);){
            this.initialCount = Mono.justOrEmpty((Object)queue).flatMap(q -> Mono.from((Publisher)q.getSizeReactive())).blockOptional();
            this.queue = Optional.of(queue);
            queue.clear();
            this.lastAdditionalInformation = (Optional)Mono.from(this.detailsReactive()).block();
        }
        catch (IOException | MailQueue.MailQueueException e) {
            LOGGER.error("Clear MailQueue got an exception", e);
            Task.Result result = Task.Result.PARTIAL;
            return result;
        }
        finally {
            this.queue = Optional.empty();
        }
        return Task.Result.COMPLETED;
    }

    public TaskType type() {
        return TYPE;
    }

    public Publisher<Optional<TaskExecutionDetails.AdditionalInformation>> detailsReactive() {
        return Mono.justOrEmpty(this.lastAdditionalInformation).switchIfEmpty(this.getAdditionalInformation()).map(Optional::of).switchIfEmpty(Mono.just(Optional.empty()));
    }

    MailQueueName getQueueName() {
        return this.queueName;
    }

    private Mono<TaskExecutionDetails.AdditionalInformation> getAdditionalInformation() {
        return Mono.justOrEmpty(this.queue).flatMap(q -> Mono.from((Publisher)q.getSizeReactive())).map(remainingSize -> new AdditionalInformation(this.queueName, this.initialCount.get(), (long)remainingSize, Clock.systemUTC().instant()));
    }

    @FunctionalInterface
    public static interface MailQueueFactory {
        public ManageableMailQueue create(MailQueueName var1) throws MailQueue.MailQueueException;
    }

    public static class UnknownSerializedQueue
    extends RuntimeException {
        public UnknownSerializedQueue(String queueName) {
            super("Unable to retrieve '" + queueName + "' queue");
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final MailQueueName mailQueueName;
        private final long initialCount;
        private final long remainingCount;
        private final Instant timestamp;

        public AdditionalInformation(MailQueueName mailQueueName, long initialCount, long remainingCount, Instant timestamp) {
            this.mailQueueName = mailQueueName;
            this.initialCount = initialCount;
            this.remainingCount = remainingCount;
            this.timestamp = timestamp;
        }

        public String getMailQueueName() {
            return this.mailQueueName.asString();
        }

        public long getInitialCount() {
            return this.initialCount;
        }

        public long getRemainingCount() {
            return this.remainingCount;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

