/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.events;

import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.metadata.schema.SchemaChangeType;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class TypeChangeEvent {
    public final SchemaChangeType changeType;
    public final UserDefinedType oldType;
    public final UserDefinedType newType;

    public static TypeChangeEvent dropped(UserDefinedType oldType) {
        return new TypeChangeEvent(SchemaChangeType.DROPPED, oldType, null);
    }

    public static TypeChangeEvent created(UserDefinedType newType) {
        return new TypeChangeEvent(SchemaChangeType.CREATED, null, newType);
    }

    public static TypeChangeEvent updated(UserDefinedType oldType, UserDefinedType newType) {
        return new TypeChangeEvent(SchemaChangeType.UPDATED, oldType, newType);
    }

    private TypeChangeEvent(SchemaChangeType changeType, UserDefinedType oldType, UserDefinedType newType) {
        this.changeType = changeType;
        this.oldType = oldType;
        this.newType = newType;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TypeChangeEvent) {
            TypeChangeEvent that = (TypeChangeEvent)other;
            return this.changeType == that.changeType && Objects.equals(this.oldType, that.oldType) && Objects.equals(this.newType, that.newType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.changeType, this.oldType, this.newType});
    }

    public String toString() {
        switch (this.changeType) {
            case CREATED: {
                return String.format("TypeChangeEvent(CREATED %s)", this.newType.getName());
            }
            case UPDATED: {
                return String.format("TypeChangeEvent(UPDATED %s=>%s)", this.oldType.getName(), this.newType.getName());
            }
            case DROPPED: {
                return String.format("TypeChangeEvent(DROPPED %s)", this.oldType.getName());
            }
        }
        throw new IllegalStateException("Unsupported change type " + (Object)((Object)this.changeType));
    }
}

