/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.projections;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.JamesExecutionProfiles;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.jmap.api.model.Preview;
import org.apache.james.jmap.api.projections.MessageFastViewPrecomputedProperties;
import org.apache.james.jmap.api.projections.MessageFastViewProjection;
import org.apache.james.jmap.cassandra.projections.table.CassandraMessageFastViewProjectionTable;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class CassandraMessageFastViewProjection
implements MessageFastViewProjection {
    public static final Logger LOGGER = LoggerFactory.getLogger(CassandraMessageFastViewProjection.class);
    private final Metric metricRetrieveHitCount;
    private final Metric metricRetrieveMissCount;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement storeStatement;
    private final PreparedStatement retrieveStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement truncateStatement;
    private final DriverExecutionProfile cachingProfile;

    @Inject
    CassandraMessageFastViewProjection(MetricFactory metricFactory, CqlSession session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.deleteStatement = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"message_fast_view_projection").whereColumn(CassandraMessageFastViewProjectionTable.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageFastViewProjectionTable.MESSAGE_ID))).build());
        this.storeStatement = session.prepare(QueryBuilder.insertInto((String)"message_fast_view_projection").value(CassandraMessageFastViewProjectionTable.MESSAGE_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageFastViewProjectionTable.MESSAGE_ID)).value(CassandraMessageFastViewProjectionTable.PREVIEW, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageFastViewProjectionTable.PREVIEW)).value(CassandraMessageFastViewProjectionTable.HAS_ATTACHMENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageFastViewProjectionTable.HAS_ATTACHMENT)).build());
        this.retrieveStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"message_fast_view_projection").all().whereColumn(CassandraMessageFastViewProjectionTable.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageFastViewProjectionTable.MESSAGE_ID))).build());
        this.truncateStatement = session.prepare(QueryBuilder.truncate((String)"message_fast_view_projection").build());
        this.cachingProfile = JamesExecutionProfiles.getCachingProfile((CqlSession)session);
        this.metricRetrieveHitCount = metricFactory.generate("MessageFastViewProjection:retrieveHitCount");
        this.metricRetrieveMissCount = metricFactory.generate("MessageFastViewProjection:retrieveMissCount");
    }

    public Mono<Void> store(MessageId messageId, MessageFastViewPrecomputedProperties precomputedProperties) {
        this.checkMessage(messageId);
        return this.cassandraAsyncExecutor.executeVoid(((BoundStatement)((BoundStatement)((BoundStatement)this.storeStatement.bind(new Object[0]).setUuid(CassandraMessageFastViewProjectionTable.MESSAGE_ID, ((CassandraMessageId)messageId).get())).setString(CassandraMessageFastViewProjectionTable.PREVIEW, precomputedProperties.getPreview().getValue())).setBoolean(CassandraMessageFastViewProjectionTable.HAS_ATTACHMENT, precomputedProperties.hasAttachment())).setExecutionProfile(this.cachingProfile));
    }

    public Mono<MessageFastViewPrecomputedProperties> retrieve(MessageId messageId) {
        this.checkMessage(messageId);
        return this.cassandraAsyncExecutor.executeSingleRow(((BoundStatement)this.retrieveStatement.bind(new Object[0]).set(CassandraMessageFastViewProjectionTable.MESSAGE_ID, (Object)((CassandraMessageId)messageId).get(), TypeCodecs.UUID)).setExecutionProfile(this.cachingProfile)).map(this::fromRow).doOnNext(preview -> this.metricRetrieveHitCount.increment()).switchIfEmpty(Mono.fromRunnable(() -> ((Metric)this.metricRetrieveMissCount).increment())).onErrorResume(e -> {
            LOGGER.error("Error while retrieving MessageFastView projection item for {}", (Object)messageId, e);
            return Mono.empty();
        });
    }

    public Mono<Void> delete(MessageId messageId) {
        this.checkMessage(messageId);
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteStatement.bind(new Object[0]).setUuid(CassandraMessageFastViewProjectionTable.MESSAGE_ID, ((CassandraMessageId)messageId).get()));
    }

    public Mono<Void> clear() {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.truncateStatement.bind(new Object[0]));
    }

    private void checkMessage(MessageId messageId) {
        Preconditions.checkNotNull((Object)messageId);
        Preconditions.checkArgument((boolean)(messageId instanceof CassandraMessageId), (Object)"MessageId type is required to be CassandraMessageId");
    }

    private MessageFastViewPrecomputedProperties fromRow(Row row) {
        return MessageFastViewPrecomputedProperties.builder().preview(Preview.from((String)((String)row.get(CassandraMessageFastViewProjectionTable.PREVIEW, TypeCodecs.TEXT)))).hasAttachment(row.getBoolean(CassandraMessageFastViewProjectionTable.HAS_ATTACHMENT)).build();
    }
}

