/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.ShapeFieldQuery;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class ShapeQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final ShapeFieldQuery shape;
    @Nullable
    private final Boolean ignoreUnmapped;
    public static final JsonpDeserializer<ShapeQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShapeQuery::setupShapeQueryDeserializer);

    private ShapeQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.shape = ApiTypeHelper.requireNonNull(builder.shape, this, "shape");
        this.ignoreUnmapped = builder.ignoreUnmapped;
    }

    public static ShapeQuery of(Function<Builder, ObjectBuilder<ShapeQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Shape;
    }

    public final String field() {
        return this.field;
    }

    public final ShapeFieldQuery shape() {
        return this.shape;
    }

    @Nullable
    public final Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.field);
        this.shape.serialize(generator, mapper);
        super.serializeInternal(generator, mapper);
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
    }

    protected static void setupShapeQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.shape(ShapeFieldQuery._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ShapeQuery> {
        private String field;
        private ShapeFieldQuery shape;
        @Nullable
        private Boolean ignoreUnmapped;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder shape(ShapeFieldQuery value) {
            this.shape = value;
            return this;
        }

        public final Builder shape(Function<ShapeFieldQuery.Builder, ObjectBuilder<ShapeFieldQuery>> fn) {
            return this.shape(fn.apply(new ShapeFieldQuery.Builder()).build());
        }

        public final Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShapeQuery build() {
            this._checkSingleUse();
            return new ShapeQuery(this);
        }
    }
}

