/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import java.io.FileNotFoundException;
import java.util.List;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.james.RunArguments;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.lifecycle.api.ConfigurationSanitizer;
import org.apache.james.protocols.lib.SslConfig;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.utils.KeystoreCreator;

public class ProtocolConfigurationSanitizer
implements ConfigurationSanitizer {
    private final ConfigurationProvider configurationProvider;
    private final KeystoreCreator keystoreCreator;
    private final FileSystem fileSystem;
    private final RunArguments runArguments;
    private final String component;

    public ProtocolConfigurationSanitizer(ConfigurationProvider configurationProvider, KeystoreCreator keystoreCreator, FileSystem fileSystem, RunArguments runArguments, String component) {
        this.configurationProvider = configurationProvider;
        this.keystoreCreator = keystoreCreator;
        this.fileSystem = fileSystem;
        this.runArguments = runArguments;
        this.component = component;
    }

    public void sanitize() throws Exception {
        if (this.runArguments.contain(RunArguments.Argument.GENERATE_KEYSTORE)) {
            HierarchicalConfiguration config = this.configurationProvider.getConfiguration(this.component);
            List configs = config.configurationsAt(this.component);
            for (HierarchicalConfiguration serverConfig : configs) {
                SslConfig sslConfig = SslConfig.parse((HierarchicalConfiguration)serverConfig);
                if (sslConfig.getKeystore() == null || this.exists(sslConfig.getKeystore())) continue;
                this.keystoreCreator.generateKeystore(sslConfig.getKeystore(), sslConfig.getSecret(), sslConfig.getKeystoreType());
            }
        }
    }

    private boolean exists(String file) {
        try {
            return this.fileSystem.getFile(file).exists();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }
}

