/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogSyntaxException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogSyntaxMessages;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.RedactedValueException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.TokenizedValueException;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class IntegerLogFieldSyntax
extends LogFieldSyntax<Long> {
    @NotNull
    public static final String SYNTAX_NAME = "integer";
    @NotNull
    private static final String REDACTED_INTEGER_STRING = "-999999999999999999";
    @NotNull
    private static final IntegerLogFieldSyntax INSTANCE = new IntegerLogFieldSyntax();

    private IntegerLogFieldSyntax() {
        super(100);
    }

    @NotNull
    public static IntegerLogFieldSyntax getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public String getSyntaxName() {
        return SYNTAX_NAME;
    }

    @Override
    public void valueToSanitizedString(int value, @NotNull ByteStringBuffer buffer) {
        buffer.append(value);
    }

    @Override
    public void valueToSanitizedString(long value, @NotNull ByteStringBuffer buffer) {
        buffer.append(value);
    }

    @Override
    public void valueToSanitizedString(@NotNull Long value, @NotNull ByteStringBuffer buffer) {
        buffer.append(value);
    }

    @Override
    public void logSanitizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Long fieldValue, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append('=');
        buffer.append(fieldValue);
    }

    @Override
    public void logSanitizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Long fieldValue, @NotNull JSONBuffer buffer) {
        buffer.appendNumber(fieldName, fieldValue);
    }

    @Override
    public void logSanitizedValueToJSONFormattedLog(@NotNull Long value, @NotNull JSONBuffer buffer) {
        buffer.appendNumber(value);
    }

    @Override
    @NotNull
    public Long parseValue(@NotNull String valueString) throws RedactedValueException, TokenizedValueException, LogSyntaxException {
        try {
            return Long.parseLong(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (this.valueStringIncludesRedactedComponent(valueString)) {
                throw new RedactedValueException(LogSyntaxMessages.ERR_INTEGER_LOG_SYNTAX_CANNOT_PARSE_REDACTED.get(), e);
            }
            if (this.valueStringIncludesTokenizedComponent(valueString)) {
                throw new TokenizedValueException(LogSyntaxMessages.ERR_INTEGER_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED.get(), e);
            }
            throw new LogSyntaxException(LogSyntaxMessages.ERR_INTEGER_LOG_SYNTAX_CANNOT_PARSE.get(), e);
        }
    }

    @Override
    public boolean valueStringIsCompletelyRedacted(@NotNull String valueString) {
        return valueString.equals("{REDACTED}") || valueString.equals(REDACTED_INTEGER_STRING);
    }

    @Override
    public boolean completelyRedactedValueConformsToSyntax() {
        return true;
    }

    @Override
    public void redactEntireValue(@NotNull ByteStringBuffer buffer) {
        buffer.append(REDACTED_INTEGER_STRING);
    }

    @Override
    public void logCompletelyRedactedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append('=');
        buffer.append(REDACTED_INTEGER_STRING);
    }

    @Override
    public void logCompletelyRedactedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull JSONBuffer buffer) {
        buffer.appendNumber(fieldName, REDACTED_INTEGER_STRING);
    }

    @Override
    public void logCompletelyRedactedValueToJSONFormattedLog(@NotNull JSONBuffer buffer) {
        buffer.appendNumber(REDACTED_INTEGER_STRING);
    }

    @Override
    public boolean supportsRedactedComponents() {
        return false;
    }

    @Override
    public boolean valueStringIncludesRedactedComponent(@NotNull String valueString) {
        return this.valueStringIsCompletelyRedacted(valueString);
    }

    @Override
    public boolean valueWithRedactedComponentsConformsToSyntax() {
        return true;
    }

    @Override
    public void logRedactedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Long fieldValue, @NotNull ByteStringBuffer buffer) {
        this.logCompletelyRedactedFieldToTextFormattedLog(fieldName, buffer);
    }

    @Override
    public void logRedactedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Long fieldValue, @NotNull JSONBuffer buffer) {
        this.logCompletelyRedactedFieldToJSONFormattedLog(fieldName, buffer);
    }

    @Override
    public void logRedactedComponentsValueToJSONFormattedLog(@NotNull Long value, @NotNull JSONBuffer buffer) {
        this.logCompletelyRedactedValueToJSONFormattedLog(buffer);
    }

    @Override
    public boolean valueStringIsCompletelyTokenized(@NotNull String valueString) {
        if (super.valueStringIsCompletelyTokenized(valueString)) {
            return true;
        }
        return valueString.length() == 19 && valueString.startsWith("-999999999") && !valueString.equals(REDACTED_INTEGER_STRING);
    }

    @Override
    public boolean completelyTokenizedValueConformsToSyntax() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tokenizeEntireValue(@NotNull Long value, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        byte[] tokenDigest;
        long longValue = value;
        byte[] valueBytes = new byte[]{(byte)(longValue >> 56 & 0xFFL), (byte)(longValue >> 48 & 0xFFL), (byte)(longValue >> 40 & 0xFFL), (byte)(longValue >> 32 & 0xFFL), (byte)(longValue >> 24 & 0xFFL), (byte)(longValue >> 16 & 0xFFL), (byte)(longValue >> 8 & 0xFFL), (byte)(longValue & 0xFFL)};
        ByteStringBuffer tempBuffer = this.getTemporaryBuffer();
        try {
            tempBuffer.append(valueBytes);
            tempBuffer.append(pepper);
            tokenDigest = this.sha256(tempBuffer);
        }
        finally {
            this.releaseTemporaryBuffer(tempBuffer);
        }
        int tokenValueInt = (tokenDigest[0] & 0x7F | 0x40) << 24 | (tokenDigest[1] & 0xFF) << 16 | (tokenDigest[2] & 0xFF) << 8 | tokenDigest[3] & 0xFF;
        String tokenDigits = String.valueOf(tokenValueInt).substring(1);
        if (tokenDigits.equals("999999999")) {
            tokenDigits = "000000000";
        }
        buffer.append("-999999999");
        buffer.append(tokenDigits);
    }

    @Override
    public void logCompletelyTokenizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Long fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append('=');
        this.tokenizeEntireValue(fieldValue, pepper, buffer);
    }

    @Override
    public void logCompletelyTokenizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Long fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendNumber(fieldName, this.tokenizeEntireValue(fieldValue, pepper));
    }

    @Override
    public void logCompletelyTokenizedValueToJSONFormattedLog(@NotNull Long value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendNumber(this.tokenizeEntireValue(value, pepper));
    }

    @Override
    public boolean supportsTokenizedComponents() {
        return false;
    }

    @Override
    public boolean valueStringIncludesTokenizedComponent(@NotNull String valueString) {
        return this.valueStringIsCompletelyTokenized(valueString);
    }

    @Override
    public boolean valueWithTokenizedComponentsConformsToSyntax() {
        return true;
    }

    @Override
    public void logTokenizedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull Long fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        this.logCompletelyTokenizedFieldToTextFormattedLog(fieldName, fieldValue, pepper, buffer);
    }

    @Override
    public void logTokenizedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull Long fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        this.logCompletelyTokenizedFieldToJSONFormattedLog(fieldName, fieldValue, pepper, buffer);
    }

    @Override
    public void logTokenizedComponentsValueToJSONFormattedLog(@NotNull Long value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        this.logCompletelyTokenizedValueToJSONFormattedLog(value, pepper, buffer);
    }
}

