/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.common.base.Joiner;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.modules.data.JPAConfiguration;
import org.apache.james.utils.PropertiesProvider;

public class JPAEntityManagerModule
extends AbstractModule {
    @Provides
    @Singleton
    public EntityManagerFactory provideEntityManagerFactory(JPAConfiguration jpaConfiguration) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("openjpa.ConnectionDriverName", jpaConfiguration.getDriverName());
        properties.put("openjpa.ConnectionURL", jpaConfiguration.getDriverURL());
        jpaConfiguration.getCredential().ifPresent(credential -> {
            properties.put("openjpa.ConnectionUserName", credential.getUsername());
            properties.put("openjpa.ConnectionPassword", credential.getPassword());
        });
        ArrayList connectionProperties = new ArrayList();
        jpaConfiguration.isTestOnBorrow().ifPresent(testOnBorrow -> connectionProperties.add("TestOnBorrow=" + testOnBorrow));
        jpaConfiguration.getValidationQueryTimeoutSec().ifPresent(timeoutSecond -> connectionProperties.add("ValidationTimeout=" + timeoutSecond * 1000));
        jpaConfiguration.getValidationQuery().ifPresent(validationQuery -> connectionProperties.add("ValidationSQL='" + validationQuery + "'"));
        jpaConfiguration.getMaxConnections().ifPresent(maxConnections -> connectionProperties.add("MaxTotal=" + maxConnections));
        connectionProperties.addAll(jpaConfiguration.getCustomDatasourceProperties().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.toList()));
        properties.put("openjpa.ConnectionProperties", Joiner.on((String)",").join(connectionProperties));
        properties.putAll(jpaConfiguration.getCustomOpenjpaProperties());
        if (jpaConfiguration.isMultithreaded().isPresent()) {
            properties.put("openjpa.Multithreaded", jpaConfiguration.isMultithreaded().get().toString());
        }
        return Persistence.createEntityManagerFactory((String)"Global", properties);
    }

    @Provides
    @Singleton
    JPAConfiguration provideConfiguration(PropertiesProvider propertiesProvider) throws FileNotFoundException, ConfigurationException {
        Configuration dataSource = propertiesProvider.getConfiguration("james-database");
        Map<String, String> openjpaProperties = JPAEntityManagerModule.getKeysForPrefix(dataSource, "openjpa", false);
        Map<String, String> datasourceProperties = JPAEntityManagerModule.getKeysForPrefix(dataSource, "datasource", true);
        return JPAConfiguration.builder().driverName(dataSource.getString("database.driverClassName")).driverURL(dataSource.getString("database.url")).testOnBorrow(dataSource.getBoolean("datasource.testOnBorrow", false)).validationQueryTimeoutSec(dataSource.getInteger("datasource.validationQueryTimeoutSec", null)).validationQuery(dataSource.getString("datasource.validationQuery", null)).maxConnections(dataSource.getInteger("datasource.maxTotal", null)).multithreaded(dataSource.getBoolean("openjpa.Multithreaded", true)).username(dataSource.getString("database.username")).password(dataSource.getString("database.password")).setCustomOpenjpaProperties(openjpaProperties).setCustomDatasourceProperties(datasourceProperties).build();
    }

    private static Map<String, String> getKeysForPrefix(Configuration dataSource, String prefix, boolean stripPrefix) {
        Iterator keys = dataSource.getKeys(prefix);
        HashMap<String, String> properties = new HashMap<String, String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String propertyKey = stripPrefix ? key.replace(prefix + ".", "") : key;
            properties.put(propertyKey, dataSource.getString(key));
        }
        return properties;
    }
}

