/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.whiteboard;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.aries.jmx.util.shared.RegistrableStandardEmitterMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MBeanHolder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Object mbean;
    private final ObjectName requestedObjectName;
    private final Map<MBeanServer, ObjectName> registrations;

    static <T> MBeanHolder create(T mbean, ObjectName requestedObjectName) {
        if (mbean instanceof DynamicMBean) {
            return new MBeanHolder(mbean, requestedObjectName);
        }
        if (mbean == null) {
            return null;
        }
        Class<?> mbeanClass = mbean.getClass();
        Class<?> mbeanInterface = MBeanHolder.getMBeanInterface(mbeanClass);
        if (mbeanInterface == null) {
            return null;
        }
        if (mbeanInterface.getName().equals(mbeanClass.getName().concat("MBean"))) {
            return new MBeanHolder(mbean, requestedObjectName);
        }
        try {
            RegistrableStandardEmitterMBean stdMbean = new RegistrableStandardEmitterMBean(mbean, mbeanInterface);
            return new MBeanHolder(stdMbean, requestedObjectName);
        }
        catch (NotCompliantMBeanException e) {
            LoggerFactory.getLogger(MBeanHolder.class).error("create: Cannot create StandardMBean for " + mbean + " of type " + mbeanClass + " for interface " + mbeanInterface, (Throwable)e);
            return null;
        }
    }

    private static Class<?> getMBeanInterface(Class<?> mbeanClass) {
        if (mbeanClass == null) {
            return null;
        }
        for (Class<?> i : mbeanClass.getInterfaces()) {
            if (i.getName().endsWith("MBean")) {
                return i;
            }
            Class<?> mbeanInterface = MBeanHolder.getMBeanInterface(i);
            if (mbeanInterface == null) continue;
            return mbeanInterface;
        }
        if (mbeanClass.getSuperclass() != null) {
            return MBeanHolder.getMBeanInterface(mbeanClass.getSuperclass());
        }
        return null;
    }

    private MBeanHolder(Object mbean, ObjectName requestedObjectName) {
        this.mbean = mbean;
        this.requestedObjectName = requestedObjectName;
        this.registrations = new IdentityHashMap<MBeanServer, ObjectName>();
    }

    void register(MBeanServer server) {
        try {
            ObjectInstance instance = server.registerMBean(this.mbean, this.requestedObjectName);
            this.registrations.put(server, instance.getObjectName());
        }
        catch (InstanceAlreadyExistsException e) {
            this.log.error("register: Failure registering MBean " + this.mbean, (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            this.log.error("register: Failure registering MBean " + this.mbean, (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            this.log.error("register: Failure registering MBean " + this.mbean, (Throwable)e);
        }
    }

    void unregister(MBeanServer server) {
        ObjectName registeredName = this.registrations.remove(server);
        if (registeredName != null) {
            this.unregister(server, registeredName);
        }
    }

    void unregister() {
        for (Map.Entry<MBeanServer, ObjectName> entry : this.registrations.entrySet()) {
            this.unregister(entry.getKey(), entry.getValue());
        }
        this.registrations.clear();
    }

    private void unregister(MBeanServer server, ObjectName name) {
        try {
            server.unregisterMBean(name);
        }
        catch (MBeanRegistrationException e) {
            this.log.error("unregister: preDeregister of " + name + " threw an exception", (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            this.log.error("unregister: Unexpected unregistration problem of MBean " + name, (Throwable)e);
        }
    }
}

