/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.packages.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;

public class PackageRequirement {
    private String filter;
    private boolean optional;
    private Bundle bundle;
    private boolean resolveable;
    private static Pattern packagePattern = Pattern.compile(".*" + Pattern.quote("(osgi.wiring.package=") + "(.*?)\\).*");

    public PackageRequirement(String filter, boolean optional, Bundle bundle, boolean resolveable) {
        this.filter = filter;
        this.optional = optional;
        this.bundle = bundle;
        this.resolveable = resolveable;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isResolveable() {
        return this.resolveable;
    }

    public String getPackageName() {
        return PackageRequirement.getPackageName(this.filter);
    }

    public static String getPackageName(String filter) {
        Matcher matcher = packagePattern.matcher(filter);
        matcher.matches();
        return matcher.group(1);
    }
}

