/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.receivers.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.component.plugins.Pauseable;
import org.apache.log4j.component.plugins.Plugin;
import org.apache.log4j.component.plugins.Receiver;
import org.apache.log4j.net.ZeroConfSupport;
import org.apache.log4j.receivers.net.AddressBased;
import org.apache.log4j.receivers.net.PortBased;
import org.apache.log4j.receivers.net.SocketNode13;
import org.apache.log4j.receivers.net.SocketNodeEventListener;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public class SocketReceiver
extends Receiver
implements Runnable,
PortBased,
Pauseable {
    private Map socketMap = new HashMap();
    private boolean paused;
    private Thread rThread;
    protected int port;
    private ServerSocket serverSocket;
    private Vector socketList = new Vector();
    public static final String ZONE = "_log4j_obj_tcpaccept_receiver.local.";
    private SocketNodeEventListener listener = null;
    private List listenerList = Collections.synchronizedList(new ArrayList());
    private boolean advertiseViaMulticastDNS;
    private ZeroConfSupport zeroConf;

    public SocketReceiver() {
    }

    public SocketReceiver(int p) {
        this.port = p;
    }

    public SocketReceiver(int p, LoggerRepository repo) {
        this.port = p;
        this.repository = repo;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int p) {
        this.port = p;
    }

    @Override
    public boolean isEquivalent(Plugin testPlugin) {
        if (testPlugin != null && testPlugin instanceof SocketReceiver) {
            SocketReceiver sReceiver = (SocketReceiver)testPlugin;
            return this.port == sReceiver.getPort() && super.isEquivalent(testPlugin);
        }
        return false;
    }

    @Override
    public void activateOptions() {
        if (!this.isActive()) {
            this.rThread = new Thread(this);
            this.rThread.setDaemon(true);
            this.rThread.start();
            if (this.advertiseViaMulticastDNS) {
                this.zeroConf = new ZeroConfSupport(ZONE, this.port, this.getName());
                this.zeroConf.advertise();
            }
            this.active = true;
        }
    }

    @Override
    public synchronized void shutdown() {
        this.getLogger().debug(this.getName() + " received shutdown request");
        this.active = false;
        if (this.rThread != null) {
            this.rThread.interrupt();
            this.rThread = null;
        }
        if (this.advertiseViaMulticastDNS) {
            this.zeroConf.unadvertise();
        }
        this.doShutdown();
    }

    private synchronized void doShutdown() {
        this.active = false;
        this.getLogger().debug(this.getName() + " doShutdown called");
        this.closeServerSocket();
        this.closeAllAcceptedSockets();
    }

    private void closeServerSocket() {
        this.getLogger().debug((Object)"{} closing server socket", this.getName());
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.serverSocket = null;
    }

    private synchronized void closeAllAcceptedSockets() {
        for (int x = 0; x < this.socketList.size(); ++x) {
            try {
                ((Socket)this.socketList.get(x)).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socketMap.clear();
        this.socketList.clear();
    }

    protected synchronized void setActive(boolean b) {
        this.active = b;
    }

    public void setAdvertiseViaMulticastDNS(boolean advertiseViaMulticastDNS) {
        this.advertiseViaMulticastDNS = advertiseViaMulticastDNS;
    }

    public boolean isAdvertiseViaMulticastDNS() {
        return this.advertiseViaMulticastDNS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.closeServerSocket();
        this.closeAllAcceptedSockets();
        try {
            this.serverSocket = new ServerSocket(this.port);
        }
        catch (Exception e) {
            this.getLogger().error((Object)("error starting SocketReceiver (" + this.getName() + "), receiver did not start"), e);
            this.active = false;
            return;
        }
        Socket socket = null;
        try {
            this.getLogger().debug("in run-about to enter while not interrupted loop");
            this.active = true;
            while (!this.rThread.isInterrupted()) {
                if (socket != null) {
                    this.getLogger().debug("socket not null - creating and starting socketnode");
                    this.socketList.add(socket);
                    SocketNode13 node = new SocketNode13(socket, this);
                    List list = this.listenerList;
                    synchronized (list) {
                        for (SocketNodeEventListener l : this.listenerList) {
                            node.addSocketNodeEventListener(l);
                        }
                    }
                    this.socketMap.put(socket, node);
                    new Thread(node).start();
                    socket = null;
                }
                this.getLogger().debug("waiting to accept socket");
                socket = this.serverSocket.accept();
                this.getLogger().debug("accepted socket");
            }
        }
        catch (Exception e) {
            this.getLogger().warn("exception while watching socket server in SocketReceiver (" + this.getName() + "), stopping");
        }
        this.getLogger().debug((Object)"{} has exited the not interrupted loop", this.getName());
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e1) {
                this.getLogger().warn("socket exception caught - socket closed");
            }
        }
        this.getLogger().debug((Object)"{} is exiting main run loop", this.getName());
    }

    public Vector getConnectedSocketDetails() {
        Vector<SocketDetail> details = new Vector<SocketDetail>(this.socketList.size());
        Enumeration enumeration = this.socketList.elements();
        while (enumeration.hasMoreElements()) {
            Socket socket = (Socket)enumeration.nextElement();
            details.add(new SocketDetail(socket, (SocketNode13)this.socketMap.get(socket)));
        }
        return details;
    }

    public SocketNodeEventListener getListener() {
        return this.listener;
    }

    public void addSocketNodeEventListener(SocketNodeEventListener l) {
        this.listenerList.add(l);
    }

    public void removeSocketNodeEventListener(SocketNodeEventListener l) {
        this.listenerList.remove(l);
    }

    public void setListener(SocketNodeEventListener l) {
        this.removeSocketNodeEventListener(l);
        this.addSocketNodeEventListener(l);
        this.listener = l;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void setPaused(boolean b) {
        this.paused = b;
    }

    @Override
    public void doPost(LoggingEvent event) {
        if (!this.isPaused()) {
            super.doPost(event);
        }
    }

    private static final class SocketDetail
    implements AddressBased,
    PortBased,
    Pauseable {
        private String address;
        private int port;
        private SocketNode13 socketNode;

        private SocketDetail(Socket socket, SocketNode13 node) {
            this.address = socket.getInetAddress().getHostName();
            this.port = socket.getPort();
            this.socketNode = node;
        }

        @Override
        public String getAddress() {
            return this.address;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public String getName() {
            return "Socket";
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public boolean isPaused() {
            return this.socketNode.isPaused();
        }

        @Override
        public void setPaused(boolean b) {
            this.socketNode.setPaused(b);
        }
    }
}

