/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.impl;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.util.Collection;
import java.util.Objects;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractKeyEntryResolver<PUB extends PublicKey, PRV extends PrivateKey>
extends AbstractLoggingBean
implements KeyEntryResolver<PUB, PRV> {
    private final Class<PUB> pubType;
    private final Class<PRV> prvType;
    private final Collection<String> names;

    protected AbstractKeyEntryResolver(Class<PUB> pubType, Class<PRV> prvType, Collection<String> names) {
        this.pubType = Objects.requireNonNull(pubType, "No public key type specified");
        this.prvType = Objects.requireNonNull(prvType, "No private key type specified");
        this.names = ValidateUtils.checkNotNullAndNotEmpty(names, "No type names provided", new Object[0]);
    }

    @Override
    public final Class<PUB> getPublicKeyType() {
        return this.pubType;
    }

    @Override
    public final Class<PRV> getPrivateKeyType() {
        return this.prvType;
    }

    @Override
    public Collection<String> getSupportedTypeNames() {
        return this.names;
    }

    public PUB generatePublicKey(KeySpec keySpec) throws GeneralSecurityException {
        KeyFactory factory = this.getKeyFactoryInstance();
        Class<PUB> keyType = this.getPublicKeyType();
        return (PUB)((PublicKey)keyType.cast(factory.generatePublic(keySpec)));
    }

    public PRV generatePrivateKey(KeySpec keySpec) throws GeneralSecurityException {
        KeyFactory factory = this.getKeyFactoryInstance();
        Class<PRV> keyType = this.getPrivateKeyType();
        return (PRV)((PrivateKey)keyType.cast(factory.generatePrivate(keySpec)));
    }

    public String toString() {
        return this.getPublicKeyType().getSimpleName() + ": " + this.getSupportedTypeNames();
    }
}

