/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.EOFException;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.channel.IoWriteFutureImpl;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;

public class BufferedIoOutputStream
extends AbstractInnerCloseable
implements IoOutputStream {
    protected final IoOutputStream out;
    protected final Queue<IoWriteFutureImpl> writes = new ConcurrentLinkedQueue<IoWriteFutureImpl>();
    protected final AtomicReference<IoWriteFutureImpl> currentWrite = new AtomicReference();
    protected final Object id;

    public BufferedIoOutputStream(Object id, IoOutputStream out) {
        this.out = out;
        this.id = id;
    }

    public Object getId() {
        return this.id;
    }

    @Override
    public IoWriteFuture writePacket(Buffer buffer) throws IOException {
        if (this.isClosing()) {
            throw new EOFException("Closed");
        }
        IoWriteFutureImpl future = new IoWriteFutureImpl(this.getId(), buffer);
        this.writes.add(future);
        this.startWriting();
        return future;
    }

    protected void startWriting() throws IOException {
        final IoWriteFutureImpl future = this.writes.peek();
        if (future == null) {
            return;
        }
        if (!this.currentWrite.compareAndSet(null, future)) {
            return;
        }
        this.out.writePacket(future.getBuffer()).addListener(new SshFutureListener<IoWriteFuture>(){

            @Override
            public void operationComplete(IoWriteFuture f) {
                if (f.isWritten()) {
                    future.setValue(Boolean.TRUE);
                } else {
                    future.setValue(f.getException());
                }
                this.finishWrite();
            }

            private void finishWrite() {
                BufferedIoOutputStream.this.writes.remove(future);
                BufferedIoOutputStream.this.currentWrite.compareAndSet(future, null);
                try {
                    BufferedIoOutputStream.this.startWriting();
                }
                catch (IOException e) {
                    BufferedIoOutputStream.this.log.error("finishWrite({}) failed ({}) re-start writing", (Object)BufferedIoOutputStream.this.out, (Object)e.getClass().getSimpleName());
                }
            }
        });
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().when(this.getId(), this.writes).close(this.out).build();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.out + "]";
    }
}

