/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.processor.loadbalancer.DistributionRatio;
import org.apache.camel.processor.loadbalancer.WeightedLoadBalancer;

public class WeightedRoundRobinLoadBalancer
extends WeightedLoadBalancer {
    int counter = -1;

    public WeightedRoundRobinLoadBalancer(List<Integer> distributionRatios) {
        super(distributionRatios);
    }

    @Override
    protected synchronized AsyncProcessor chooseProcessor(AsyncProcessor[] processors, Exchange exchange) {
        DistributionRatio ratio;
        int counter = this.counter;
        List<DistributionRatio> ratios = this.getRatios();
        do {
            if (++counter < ratios.size()) continue;
            counter = 0;
        } while (!(ratio = ratios.get(counter)).decrement());
        this.counter = this.lastIndex = counter;
        this.decrementSum();
        return processors[counter];
    }

    @Override
    protected void reset() {
        super.reset();
        this.counter = -1;
    }
}

