/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.xml;

import java.util.ArrayList;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.analysis.DefaultAnalyserFactory;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.document.impl.util.DocumentAnalyserMultiplexer;
import org.apache.rat.policy.DefaultPolicy;
import org.apache.rat.report.AbstractReport;
import org.apache.rat.report.RatReport;
import org.apache.rat.report.claim.ClaimStatistic;
import org.apache.rat.report.claim.impl.ClaimAggregator;
import org.apache.rat.report.claim.impl.xml.SimpleXmlClaimReporter;
import org.apache.rat.report.claim.util.ClaimReporterMultiplexer;
import org.apache.rat.report.claim.util.LicenseAddingReport;
import org.apache.rat.report.xml.writer.IXmlWriter;

public class XmlReportFactory {
    public static final RatReport createStandardReport(IXmlWriter writer, ClaimStatistic pStatistic, ReportConfiguration pConfiguration) {
        ArrayList<AbstractReport> reporters = new ArrayList<AbstractReport>();
        if (pStatistic != null) {
            reporters.add(new ClaimAggregator(pStatistic));
        }
        if (pConfiguration.isAddingLicenses()) {
            reporters.add(new LicenseAddingReport(pConfiguration.getCopyrightMessage(), pConfiguration.isAddingLicensesForced()));
        }
        reporters.add(new SimpleXmlClaimReporter(writer));
        IDocumentAnalyser analyser = DefaultAnalyserFactory.createDefaultAnalyser(pConfiguration.getHeaderMatcher());
        DefaultPolicy policy = new DefaultPolicy(pConfiguration.getApprovedLicenseNames(), pConfiguration.isApproveDefaultLicenses());
        IDocumentAnalyser[] analysers = new IDocumentAnalyser[]{analyser, policy};
        DocumentAnalyserMultiplexer analysisMultiplexer = new DocumentAnalyserMultiplexer(analysers);
        return new ClaimReporterMultiplexer(analysisMultiplexer, reporters);
    }
}

