/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.openpgp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.functors.UnaryEquator;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.openpgp.PGPAuthorizedKeyEntriesLoader;
import org.apache.sshd.openpgp.PGPUtils;
import org.bouncycastle.openpgp.PGPException;
import org.c02e.jpgpj.Ring;
import org.c02e.jpgpj.Subkey;

public class PGPPublicRingWatcher
extends ModifiableFileWatcher
implements PGPAuthorizedKeyEntriesLoader {
    public static final String GPG_V1_PUBLIC_RING_FILENAME = "pubring.gpg";
    public static final String GPG_V2_PUBLIC_RING_FILENAME = "pubring.kbx";
    public static final List<String> PUBLIC_RING_FILES = Collections.unmodifiableList(Arrays.asList("pubring.kbx", "pubring.gpg"));
    protected final AtomicReference<NavigableMap<String, PublicKey>> ringKeys = new AtomicReference(Collections.emptyNavigableMap());

    public PGPPublicRingWatcher(Path file) {
        super(file);
    }

    @Override
    public List<PublicKey> loadMatchingKeyFingerprints(SessionContext session, Collection<String> fingerprints) throws IOException, GeneralSecurityException, PGPException {
        int numEntries = GenericUtils.size(fingerprints);
        if (numEntries <= 0) {
            return Collections.emptyList();
        }
        NavigableMap<String, PublicKey> keysMap = this.resolveRingKeys(session);
        if (MapEntryUtils.isEmpty(keysMap)) {
            return Collections.emptyList();
        }
        List<PublicKey> matches = Collections.emptyList();
        for (String fp : fingerprints) {
            PublicKey key = (PublicKey)keysMap.get(fp);
            if (key == null) continue;
            if (GenericUtils.isEmpty(matches)) {
                matches = new ArrayList<PublicKey>(numEntries);
            }
            matches.add(key);
        }
        return matches;
    }

    protected NavigableMap<String, PublicKey> resolveRingKeys(SessionContext session) throws IOException, GeneralSecurityException, PGPException {
        NavigableMap<String, PublicKey> keysMap = this.ringKeys.get();
        if (MapEntryUtils.isEmpty(keysMap) || this.checkReloadRequired()) {
            this.ringKeys.set(Collections.emptyNavigableMap());
            if (!this.exists()) {
                return this.ringKeys.get();
            }
            Path file = this.getPath();
            keysMap = this.reloadRingKeys(session, (IoResource<?>)new PathResource(file));
            int numKeys = MapEntryUtils.size(keysMap);
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveRingKeys({}) reloaded {} keys from {}", new Object[]{session, numKeys, file});
            }
            if (numKeys > 0) {
                this.ringKeys.set(keysMap);
                this.updateReloadAttributes();
            }
        }
        return keysMap;
    }

    protected NavigableMap<String, PublicKey> reloadRingKeys(SessionContext session, IoResource<?> resourceKey) throws IOException, GeneralSecurityException, PGPException {
        Ring ring;
        try (InputStream stream = resourceKey.openInputStream();){
            ring = new Ring(stream);
        }
        return this.reloadRingKeys(session, (NamedResource)resourceKey, ring);
    }

    protected NavigableMap<String, PublicKey> reloadRingKeys(SessionContext session, NamedResource resourceKey, Ring ring) throws IOException, GeneralSecurityException, PGPException {
        return this.reloadRingKeys(session, resourceKey, ring.getKeys());
    }

    protected NavigableMap<String, PublicKey> reloadRingKeys(SessionContext session, NamedResource resourceKey, Collection<org.c02e.jpgpj.Key> keys) throws IOException, GeneralSecurityException, PGPException {
        if (GenericUtils.isEmpty(keys)) {
            return Collections.emptyNavigableMap();
        }
        TreeMap<String, PublicKey> keysMap = new TreeMap<String, PublicKey>(String.CASE_INSENSITIVE_ORDER);
        boolean debugEnabled = this.log.isDebugEnabled();
        for (org.c02e.jpgpj.Key k : keys) {
            NavigableMap<String, Subkey> subKeys = PGPUtils.mapSubKeysByFingerprint(k);
            for (Map.Entry se : subKeys.entrySet()) {
                PublicKey prev;
                PublicKey pubKey;
                String fp = (String)se.getKey();
                Subkey sk = (Subkey)se.getValue();
                try {
                    pubKey = this.extractPublicKey(resourceKey, sk);
                }
                catch (IOException | RuntimeException | GeneralSecurityException e) {
                    pubKey = this.handlePublicKeyExtractionError(session, resourceKey, fp, sk, e);
                }
                if (debugEnabled) {
                    this.log.debug("reloadRingKeys({}) loaded {} key ({}) for fingerprint={} from {}", new Object[]{session, KeyUtils.getKeyType((Key)pubKey), KeyUtils.getFingerPrint((PublicKey)pubKey), fp, resourceKey.getName()});
                }
                if (pubKey == null || (prev = keysMap.put(fp, pubKey)) == null) continue;
                PublicKey effective = this.handleDuplicateKeyFingerprint(session, resourceKey, fp, sk, prev, pubKey);
                if (effective == null) {
                    keysMap.remove(fp);
                    continue;
                }
                if (UnaryEquator.isSameReference((Object)effective, (Object)pubKey)) continue;
                keysMap.put(fp, effective);
            }
        }
        return keysMap;
    }

    protected PublicKey handlePublicKeyExtractionError(SessionContext session, NamedResource resourceKey, String fingerprint, Subkey subKey, Throwable reason) throws IOException, GeneralSecurityException, PGPException {
        this.log.warn("handlePublicKeyExtractionError({}) failed ({}) to extract value for fingerprint={} from {}: {}", new Object[]{session, reason.getClass().getSimpleName(), fingerprint, resourceKey.getName(), reason.getMessage()});
        return null;
    }

    protected PublicKey handleDuplicateKeyFingerprint(SessionContext session, NamedResource resourceKey, String fingerprint, Subkey subKey, PublicKey k1, PublicKey k2) throws IOException, GeneralSecurityException, PGPException {
        this.log.warn("handleDuplicateKeyFingerprint({}) duplicate keys found for fingerprint={} ({}[{}] / {}[{}]) in {}", new Object[]{session, fingerprint, KeyUtils.getKeyType((Key)k1), KeyUtils.getFingerPrint((PublicKey)k1), KeyUtils.getKeyType((Key)k2), KeyUtils.getFingerPrint((PublicKey)k2), resourceKey.getName()});
        return k2;
    }

    @Override
    public <K extends PublicKey> K generatePublicKey(String algorithm, Class<K> keyType, KeySpec keySpec) throws GeneralSecurityException {
        KeyFactory factory = this.getKeyFactory(algorithm);
        PublicKey pubKey = factory.generatePublic(keySpec);
        return (K)((PublicKey)keyType.cast(pubKey));
    }

    protected KeyFactory getKeyFactory(String algorithm) throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory((String)algorithm);
    }

    public static Path detectDefaultPublicRingFilePath() {
        return PGPPublicRingWatcher.detectDefaultPublicRingFilePath(PGPUtils.getDefaultPgpFolderPath());
    }

    public static Path detectDefaultPublicRingFilePath(Path dir) {
        for (String name : PUBLIC_RING_FILES) {
            Path file = dir.resolve(name);
            if (!Files.exists(file, new LinkOption[0]) || !Files.isRegularFile(file, new LinkOption[0]) || !Files.isReadable(file)) continue;
            return file;
        }
        return null;
    }
}

