/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import jakarta.faces.application.ResourceVisitOption;
import jakarta.faces.context.FacesContext;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.myfaces.shared.resource.ResourceHandlerSupport;
import org.apache.myfaces.shared.resource.ResourceLoader;

public class ViewResourceIterator
implements Iterator<String> {
    private ResourceHandlerSupport support;
    private Deque<ResourceLoader> stack = new LinkedList<ResourceLoader>();
    private Deque<String> basePathStack = new LinkedList<String>();
    private Iterator<String> currentIterator = null;
    private String origBasePath;
    private int maxDepth;
    private ResourceVisitOption[] options;
    private FacesContext facesContext;
    private Set<String> pathSet;

    public ViewResourceIterator(FacesContext facesContext, ResourceHandlerSupport support, String localePrefix, List<String> contracts, String contractPreferred, String path, int maxDepth, ResourceVisitOption ... options) {
        String basePath;
        this.support = support;
        this.origBasePath = path;
        this.maxDepth = maxDepth;
        this.options = options;
        this.facesContext = facesContext;
        String string = basePath = this.origBasePath.endsWith("/") ? this.origBasePath : this.origBasePath + "/";
        if (contractPreferred != null) {
            for (ResourceLoader resourceLoader : support.getContractResourceLoaders()) {
                if (localePrefix != null) {
                    this.stack.add(resourceLoader);
                    this.basePathStack.add(basePath + localePrefix + "/" + contractPreferred);
                }
                this.stack.add(resourceLoader);
                this.basePathStack.add(basePath + "/" + contractPreferred);
            }
        }
        if (!contracts.isEmpty()) {
            for (ResourceLoader resourceLoader : support.getContractResourceLoaders()) {
                for (String contract : contracts) {
                    if (localePrefix != null) {
                        this.stack.add(resourceLoader);
                        this.basePathStack.add(basePath + localePrefix + "/" + contract);
                    }
                    this.stack.add(resourceLoader);
                    this.basePathStack.add(basePath + contract);
                }
            }
        }
        for (ResourceLoader resourceLoader : support.getViewResourceLoaders()) {
            if (localePrefix != null) {
                this.stack.add(resourceLoader);
                this.basePathStack.add(basePath + localePrefix);
            }
            this.stack.add(resourceLoader);
            this.basePathStack.add(basePath);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean hasNext() {
        next = false;
        do {
            block4: {
                if (this.currentIterator != null) break block4;
                loader = null;
                basePath = null;
                do lbl-1000:
                // 3 sources

                {
                    loader = this.stack.pop();
                    basePath = this.basePathStack.pop();
                    if (loader != null) {
                        this.currentIterator = loader.iterator(this.facesContext, basePath, this.maxDepth, this.options);
                    }
                    if (this.currentIterator == null && !this.stack.isEmpty()) ** GOTO lbl-1000
                    if (this.currentIterator == null || (hasNext = this.currentIterator.hasNext())) continue;
                    this.currentIterator = null;
                } while (this.currentIterator == null && !this.stack.isEmpty());
                if (this.currentIterator == null) {
                    return false;
                }
            }
            if ((next = this.currentIterator.hasNext()) || this.stack.isEmpty()) continue;
            this.currentIterator = null;
        } while (this.currentIterator == null);
        return next;
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            if (this.currentIterator != null) {
                return this.currentIterator.next();
            }
            return null;
        }
        return null;
    }
}

