/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;
import java.util.List;
import org.apache.nifi.web.api.dto.FlowFileSummaryDTO;
import org.apache.nifi.web.api.dto.QueueSizeDTO;
import org.apache.nifi.web.api.dto.util.TimeAdapter;
import org.apache.nifi.web.api.dto.util.TimestampAdapter;

@XmlType(name="listingRequest")
public class ListingRequestDTO {
    private String id;
    private String uri;
    private Date submissionTime;
    private Date lastUpdated;
    private Integer percentCompleted;
    private Boolean finished;
    private String failureReason;
    private Integer maxResults;
    private Boolean isSourceRunning;
    private Boolean isDestinationRunning;
    private String state;
    private QueueSizeDTO queueSize;
    private List<FlowFileSummaryDTO> flowFileSummaries;

    @Schema(description="The id for this listing request.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Schema(description="The URI for future requests to this listing request.")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @XmlJavaTypeAdapter(value=TimestampAdapter.class)
    @Schema(description="The timestamp when the query was submitted.", type="string")
    public Date getSubmissionTime() {
        return this.submissionTime;
    }

    public void setSubmissionTime(Date submissionTime) {
        this.submissionTime = submissionTime;
    }

    @XmlJavaTypeAdapter(value=TimeAdapter.class)
    @Schema(description="The last time this listing request was updated.", type="string")
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    @Schema(description="The current percent complete.")
    public Integer getPercentCompleted() {
        return this.percentCompleted;
    }

    public void setPercentCompleted(Integer percentCompleted) {
        this.percentCompleted = percentCompleted;
    }

    @Schema(description="Whether the query has finished.")
    public Boolean getFinished() {
        return this.finished;
    }

    public void setFinished(Boolean finished) {
        this.finished = finished;
    }

    @Schema(description="The reason, if any, that this listing request failed.")
    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    @Schema(description="The current state of the listing request.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Schema(description="The FlowFile summaries. The summaries will be populated once the request has completed.")
    public List<FlowFileSummaryDTO> getFlowFileSummaries() {
        return this.flowFileSummaries;
    }

    public void setFlowFileSummaries(List<FlowFileSummaryDTO> flowFileSummaries) {
        this.flowFileSummaries = flowFileSummaries;
    }

    @Schema(description="The maximum number of FlowFileSummary objects to return")
    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    @Schema(description="The size of the queue")
    public QueueSizeDTO getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(QueueSizeDTO queueSize) {
        this.queueSize = queueSize;
    }

    @Schema(description="Whether the source of the connection is running")
    public Boolean getSourceRunning() {
        return this.isSourceRunning;
    }

    public void setSourceRunning(Boolean sourceRunning) {
        this.isSourceRunning = sourceRunning;
    }

    @Schema(description="Whether the destination of the connection is running")
    public Boolean getDestinationRunning() {
        return this.isDestinationRunning;
    }

    public void setDestinationRunning(Boolean destinationRunning) {
        this.isDestinationRunning = destinationRunning;
    }
}

