/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.Position;

public abstract class VersionedComponent {
    private String identifier;
    private String instanceIdentifier;
    private String groupId;
    private String name;
    private String comments;
    private Position position;

    @Schema(description="The component's unique identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Schema(description="The instance ID of an existing component that is described by this VersionedComponent, or null if this is not mapped to an instantiated component")
    public String getInstanceIdentifier() {
        return this.instanceIdentifier;
    }

    public void setInstanceIdentifier(String instanceIdentifier) {
        this.instanceIdentifier = instanceIdentifier;
    }

    @Schema(description="The ID of the Process Group that this component belongs to")
    public String getGroupIdentifier() {
        return this.groupId;
    }

    public void setGroupIdentifier(String groupId) {
        this.groupId = groupId;
    }

    @Schema(description="The component's name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="The component's position on the graph")
    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    @Schema(description="The user-supplied comments for the component")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public abstract ComponentType getComponentType();

    public void setComponentType(ComponentType type) {
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VersionedComponent)) {
            return false;
        }
        VersionedComponent other = (VersionedComponent)obj;
        return Objects.equals(this.identifier, other.identifier);
    }
}

