/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;

public class GetAsset
extends AbstractNiFiCommand<VoidResult> {
    public GetAsset() {
        super("get-asset", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Retrieves the content of the given asset.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_CONTEXT_ID.createOption());
        this.addOption(CommandOption.ASSET_ID.createOption());
        this.addOption(CommandOption.OUTPUT_DIR.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramContextId = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_ID);
        String assetId = this.getRequiredArg(properties, CommandOption.ASSET_ID);
        File outputDir = new File(this.getRequiredArg(properties, CommandOption.OUTPUT_DIR));
        Path assetFile = client.getParamContextClient().getAssetContent(paramContextId, assetId, outputDir);
        if (this.isInteractive()) {
            this.println(assetFile.toFile().getAbsolutePath());
        }
        return VoidResult.getInstance();
    }
}

