/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.topic;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.client.impl.producer.TopicPublishInfo;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;
import org.apache.rocketmq.remoting.protocol.route.BrokerData;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;

public class TopicRouteInfoManager {
    private static final long GET_TOPIC_ROUTE_TIMEOUT = 3000L;
    private static final long LOCK_TIMEOUT_MILLIS = 3000L;
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final Lock lockNamesrv = new ReentrantLock();
    private final ConcurrentMap<String, TopicRouteData> topicRouteTable = new ConcurrentHashMap<String, TopicRouteData>();
    private final ConcurrentMap<String, HashMap<Long, String>> brokerAddrTable = new ConcurrentHashMap<String, HashMap<Long, String>>();
    private final ConcurrentMap<String, TopicPublishInfo> topicPublishInfoTable = new ConcurrentHashMap<String, TopicPublishInfo>();
    private final ConcurrentHashMap<String, Set<MessageQueue>> topicSubscribeInfoTable = new ConcurrentHashMap();
    private ScheduledExecutorService scheduledExecutorService;
    private BrokerController brokerController;

    public TopicRouteInfoManager(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public void start() {
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "TopicRouteInfoManagerScheduledThread");
            }
        });
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                this.updateTopicRouteInfoFromNameServer();
            }
            catch (Exception e) {
                log.error("ScheduledTask: failed to pull TopicRouteData from NameServer", (Throwable)e);
            }
        }, 1000L, this.brokerController.getBrokerConfig().getLoadBalancePollNameServerInterval(), TimeUnit.MILLISECONDS);
    }

    private void updateTopicRouteInfoFromNameServer() {
        Set topicSetForPopAssignment = this.topicSubscribeInfoTable.keySet();
        Set topicSetForEscapeBridge = this.topicRouteTable.keySet();
        Sets.SetView topicsAll = Sets.union((Set)topicSetForPopAssignment, topicSetForEscapeBridge);
        for (String topic : topicsAll) {
            boolean isNeedUpdatePublishInfo = topicSetForEscapeBridge.contains(topic);
            boolean isNeedUpdateSubscribeInfo = topicSetForPopAssignment.contains(topic);
            this.updateTopicRouteInfoFromNameServer(topic, isNeedUpdatePublishInfo, isNeedUpdateSubscribeInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTopicRouteInfoFromNameServer(String topic, boolean isNeedUpdatePublishInfo, boolean isNeedUpdateSubscribeInfo) {
        block14: {
            try {
                if (!this.lockNamesrv.tryLock(3000L, TimeUnit.MILLISECONDS)) break block14;
                try {
                    TopicRouteData topicRouteData = this.brokerController.getBrokerOuterAPI().getTopicRouteInfoFromNameServer(topic, 3000L);
                    if (null == topicRouteData) {
                        log.warn("TopicRouteInfoManager: updateTopicRouteInfoFromNameServer, getTopicRouteInfoFromNameServer return null, Topic: {}.", (Object)topic);
                        return;
                    }
                    if (isNeedUpdateSubscribeInfo) {
                        this.updateSubscribeInfoTable(topicRouteData, topic);
                    }
                    if (isNeedUpdatePublishInfo) {
                        this.updateTopicRouteTable(topic, topicRouteData);
                    }
                }
                catch (RemotingException e) {
                    log.error("updateTopicRouteInfoFromNameServer Exception", (Throwable)e);
                }
                catch (MQBrokerException e) {
                    log.error("updateTopicRouteInfoFromNameServer Exception", (Throwable)e);
                    if (!NamespaceUtil.isRetryTopic((String)topic) && 17 == e.getResponseCode()) {
                        this.cleanNoneRouteTopic(topic);
                    }
                }
                finally {
                    this.lockNamesrv.unlock();
                }
            }
            catch (InterruptedException e) {
                log.warn("updateTopicRouteInfoFromNameServer Exception", (Throwable)e);
            }
        }
    }

    private boolean updateTopicRouteTable(String topic, TopicRouteData topicRouteData) {
        TopicRouteData old = (TopicRouteData)this.topicRouteTable.get(topic);
        boolean changed = topicRouteData.topicRouteDataChanged(old);
        if (!changed) {
            if (!this.isNeedUpdateTopicRouteInfo(topic)) {
                return false;
            }
        } else {
            log.info("the topic[{}] route info changed, old[{}] ,new[{}]", new Object[]{topic, old, topicRouteData});
        }
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            this.brokerAddrTable.put(bd.getBrokerName(), bd.getBrokerAddrs());
        }
        TopicPublishInfo publishInfo = MQClientInstance.topicRouteData2TopicPublishInfo((String)topic, (TopicRouteData)topicRouteData);
        publishInfo.setHaveTopicRouterInfo(true);
        this.updateTopicPublishInfo(topic, publishInfo);
        TopicRouteData cloneTopicRouteData = new TopicRouteData(topicRouteData);
        log.info("topicRouteTable.put. Topic = {}, TopicRouteData[{}]", (Object)topic, (Object)cloneTopicRouteData);
        this.topicRouteTable.put(topic, cloneTopicRouteData);
        return true;
    }

    private boolean updateSubscribeInfoTable(TopicRouteData topicRouteData, String topic) {
        TopicRouteData tmp = new TopicRouteData(topicRouteData);
        tmp.setTopicQueueMappingByBroker(null);
        Set newSubscribeInfo = MQClientInstance.topicRouteData2TopicSubscribeInfo((String)topic, (TopicRouteData)tmp);
        Set<MessageQueue> oldSubscribeInfo = this.topicSubscribeInfoTable.get(topic);
        if (Objects.equals(newSubscribeInfo, oldSubscribeInfo)) {
            return false;
        }
        log.info("the topic[{}] subscribe message queue changed, old[{}] ,new[{}]", new Object[]{topic, oldSubscribeInfo, newSubscribeInfo});
        this.topicSubscribeInfoTable.put(topic, newSubscribeInfo);
        return true;
    }

    private boolean isNeedUpdateTopicRouteInfo(String topic) {
        TopicPublishInfo prev = (TopicPublishInfo)this.topicPublishInfoTable.get(topic);
        return null == prev || !prev.ok();
    }

    private void cleanNoneRouteTopic(String topic) {
        this.topicSubscribeInfoTable.remove(topic);
    }

    private void updateTopicPublishInfo(String topic, TopicPublishInfo info) {
        TopicPublishInfo prev;
        if (info != null && topic != null && (prev = this.topicPublishInfoTable.put(topic, info)) != null) {
            log.info("updateTopicPublishInfo prev is not null, " + prev);
        }
    }

    public void shutdown() {
        if (null != this.scheduledExecutorService) {
            this.scheduledExecutorService.shutdown();
        }
    }

    public TopicPublishInfo tryToFindTopicPublishInfo(String topic) {
        TopicPublishInfo topicPublishInfo = (TopicPublishInfo)this.topicPublishInfoTable.get(topic);
        if (null == topicPublishInfo || !topicPublishInfo.ok()) {
            this.updateTopicRouteInfoFromNameServer(topic, true, false);
            topicPublishInfo = (TopicPublishInfo)this.topicPublishInfoTable.get(topic);
        }
        return topicPublishInfo;
    }

    public String findBrokerAddressInPublish(String brokerName) {
        if (brokerName == null) {
            return null;
        }
        Map map = (Map)this.brokerAddrTable.get(brokerName);
        if (map != null && !map.isEmpty()) {
            return (String)map.get(0L);
        }
        return null;
    }

    public String findBrokerAddressInSubscribe(String brokerName, long brokerId, boolean onlyThisBroker) {
        if (brokerName == null) {
            return null;
        }
        String brokerAddr = null;
        boolean found = false;
        Map map = (Map)this.brokerAddrTable.get(brokerName);
        if (map != null && !map.isEmpty()) {
            brokerAddr = (String)map.get(brokerId);
            boolean slave = brokerId != 0L;
            boolean bl = found = brokerAddr != null;
            if (!found && slave) {
                brokerAddr = (String)map.get(brokerId + 1L);
                boolean bl2 = found = brokerAddr != null;
            }
            if (!found && !onlyThisBroker) {
                Map.Entry entry = map.entrySet().iterator().next();
                brokerAddr = (String)entry.getValue();
                found = true;
            }
        }
        return brokerAddr;
    }

    public Set<MessageQueue> getTopicSubscribeInfo(String topic) {
        Set<MessageQueue> queues = this.topicSubscribeInfoTable.get(topic);
        if (null == queues || queues.isEmpty()) {
            this.updateTopicRouteInfoFromNameServer(topic, false, true);
            queues = this.topicSubscribeInfoTable.get(topic);
        }
        return queues;
    }
}

