/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;
import org.apache.derby.shared.common.i18n.MessageService;

abstract class RealBasicNoPutResultSetStatistics
implements ResultSetStatistics {
    public int numOpens;
    public int rowsSeen;
    public int rowsFiltered;
    public long constructorTime;
    public long openTime;
    public long nextTime;
    public long closeTime;
    public long inspectOverall;
    public long inspectNum;
    public String inspectDesc;
    public double optimizerEstimatedRowCount;
    public double optimizerEstimatedCost;

    public RealBasicNoPutResultSetStatistics(int n, int n2, int n3, long l, long l2, long l3, long l4, double d, double d2) {
        this.numOpens = n;
        this.rowsSeen = n2;
        this.rowsFiltered = n3;
        this.constructorTime = l;
        this.openTime = l2;
        this.nextTime = l3;
        this.closeTime = l4;
        this.optimizerEstimatedRowCount = d;
        this.optimizerEstimatedCost = d2;
    }

    protected final String dumpTimeStats(String string, String string2) {
        return string2 + MessageService.getTextMessage((String)"42Z33.U", (Object[])new Object[0]) + " " + this.constructorTime + "\n" + string2 + MessageService.getTextMessage((String)"42Z34.U", (Object[])new Object[0]) + " " + this.openTime + "\n" + string2 + MessageService.getTextMessage((String)"42Z35.U", (Object[])new Object[0]) + " " + this.nextTime + "\n" + string2 + MessageService.getTextMessage((String)"42Z36.U", (Object[])new Object[0]) + " " + this.closeTime;
    }

    protected final String dumpEstimatedCosts(String string) {
        return string + MessageService.getTextMessage((String)"43X07.U", (Object[])new Object[]{this.optimizerEstimatedRowCount}) + "\n" + string + MessageService.getTextMessage((String)"43X08.U", (Object[])new Object[]{this.optimizerEstimatedCost});
    }

    public Vector<ResultSetStatistics> getChildren() {
        return new Vector<ResultSetStatistics>();
    }

    public long getTotalTime() {
        return this.openTime + this.nextTime + this.closeTime;
    }

    public long getChildrenTime() {
        long l = 0L;
        Enumeration<ResultSetStatistics> enumeration = this.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            l += ((RealBasicNoPutResultSetStatistics)enumeration.nextElement()).getTotalTime();
        }
        return l;
    }

    public long getNodeTime() {
        return this.getTotalTime() - this.getChildrenTime();
    }

    public abstract String getNodeName();

    public String getNodeOn() {
        return "";
    }

    @Override
    public double getEstimatedRowCount() {
        return this.optimizerEstimatedRowCount;
    }

    @Override
    public String getRSXplainDetails() {
        return null;
    }

    @Override
    public Object getResultSetDescriptor(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return new XPLAINResultSetDescriptor((UUID)object, this.getRSXplainType(), this.getRSXplainDetails(), this.numOpens, null, null, null, (UUID)object2, this.optimizerEstimatedRowCount, this.optimizerEstimatedCost, null, null, null, this.rowsSeen, null, this.rowsFiltered, this.rowsSeen - this.rowsFiltered, null, null, (UUID)object3, (UUID)object4, (UUID)object5, (UUID)object6);
    }

    @Override
    public Object getResultSetTimingsDescriptor(Object object) {
        return new XPLAINResultSetTimingsDescriptor((UUID)object, this.constructorTime, this.openTime, this.nextTime, this.closeTime, this.getNodeTime(), XPLAINUtil.getAVGNextTime(this.nextTime, this.rowsSeen), null, null, null, null);
    }

    @Override
    public Object getSortPropsDescriptor(Object object) {
        return null;
    }

    @Override
    public Object getScanPropsDescriptor(Object object) {
        return null;
    }
}

