/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.impl;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.ConfigurationResolveException;
import org.apache.sling.caconfig.impl.metadata.AnnotationClassParser;
import org.apache.sling.caconfig.spi.metadata.PropertyMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConfigurationProxy {
    private ConfigurationProxy() {
    }

    @NotNull
    public static <T> T get(@Nullable Resource resource, @NotNull Class<T> clazz, ChildResolver childResolver) {
        if (!clazz.isAnnotation()) {
            throw new ConfigurationResolveException("Annotation interface class expected: " + clazz.getName());
        }
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new CachingInvocationHandler(new DynamicProxyInvocationHandler(resource, childResolver)));
    }

    static class CachingInvocationHandler
    implements InvocationHandler {
        private final InvocationHandler delegate;
        private final Map<String, Object> results = new HashMap<String, Object>();
        private static final Object NULL_OBJECT = new Object();

        public CachingInvocationHandler(InvocationHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String key = method.getName();
            Object result = this.results.get(key);
            if (result == null) {
                result = this.delegate.invoke(proxy, method, args);
                if (result == null) {
                    result = NULL_OBJECT;
                }
                this.results.put(key, result);
            }
            if (result == NULL_OBJECT) {
                return null;
            }
            return result;
        }
    }

    static class DynamicProxyInvocationHandler
    implements InvocationHandler {
        private final Resource resource;
        private final ChildResolver childResolver;

        private DynamicProxyInvocationHandler(Resource resource, ChildResolver childResolver) {
            this.resource = resource;
            this.childResolver = childResolver;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String propName = AnnotationClassParser.getPropertyName(method.getName());
            Class<?> targetType = method.getReturnType();
            Class<?> componentType = method.getReturnType();
            boolean isArray = targetType.isArray();
            if (isArray) {
                componentType = targetType.getComponentType();
            }
            if (componentType.isAnnotation()) {
                if (isArray) {
                    Collection<?> listItems = this.childResolver.getChildren(propName, componentType);
                    return listItems.toArray((Object[])Array.newInstance(componentType, listItems.size()));
                }
                return this.childResolver.getChild(propName, componentType);
            }
            if (!this.isValidType(componentType)) {
                throw new ConfigurationResolveException("Unsupported type " + componentType.getName() + " in " + method.getDeclaringClass() + "#" + method.getName());
            }
            Object defaultValue = method.getDefaultValue();
            if (defaultValue == null) {
                if (isArray) {
                    defaultValue = Array.newInstance(componentType, 0);
                } else if (targetType.isPrimitive()) {
                    defaultValue = Array.get(Array.newInstance(targetType, 1), 0);
                }
            }
            ValueMap props = ResourceUtil.getValueMap((Resource)this.resource);
            Object value = defaultValue != null ? props.get(propName, defaultValue) : props.get(propName, targetType);
            return value;
        }

        private boolean isValidType(Class<?> type) {
            return PropertyMetadata.SUPPORTED_TYPES.contains(type);
        }
    }

    public static interface ChildResolver {
        public <T> T getChild(String var1, Class<T> var2);

        public <T> Collection<T> getChildren(String var1, Class<T> var2);
    }
}

