/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager.post;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.authorization.PrincipalAccessControlList;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.jcr.jackrabbit.accessmanager.LocalPrivilege;
import org.apache.sling.jcr.jackrabbit.accessmanager.LocalRestriction;
import org.apache.sling.jcr.jackrabbit.accessmanager.impl.PrivilegesHelper;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.AbstractAccessServlet;
import org.apache.sling.jcr.jackrabbit.accessmanager.post.DeclarationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAccessGetServlet
extends AbstractAccessServlet {
    protected void doGet(SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws ServletException, IOException {
        try {
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            String resourcePath = this.getItemPath(request);
            String principalId = request.getParameter("pid");
            JsonObject jsonObj = this.internalJson(session, resourcePath, principalId);
            response.setContentType("application/json");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            boolean isTidy = false;
            String[] selectors = request.getRequestPathInfo().getSelectors();
            if (selectors.length > 0) {
                for (String level : selectors) {
                    if (!"tidy".equals(level)) continue;
                    isTidy = true;
                    break;
                }
            }
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("jakarta.json.stream.JsonGenerator.prettyPrinting", isTidy);
            try (JsonGenerator generator = Json.createGeneratorFactory(options).createGenerator((Writer)response.getWriter());){
                generator.write((JsonValue)jsonObj).flush();
            }
        }
        catch (AccessDeniedException ade) {
            response.sendError(404);
        }
        catch (ResourceNotFoundException rnfe) {
            response.sendError(404, rnfe.getMessage());
        }
        catch (Exception throwable) {
            throw new ServletException(String.format("Exception while handling GET %s with %s", request.getResource().getPath(), ((Object)((Object)this)).getClass().getName()), (Throwable)throwable);
        }
    }

    @Nullable
    protected String getItemPath(SlingJakartaHttpServletRequest request) {
        return request.getResource().getPath();
    }

    protected abstract JsonObject internalJson(Session var1, String var2, String var3) throws RepositoryException;

    @NotNull
    protected Principal validateArgs(Session jcrSession, String resourcePath, String principalId) throws RepositoryException {
        this.validateArgs(jcrSession, resourcePath);
        if (principalId == null) {
            throw new RepositoryException("principalId was not submitted.");
        }
        PrincipalManager principalManager = ((JackrabbitSession)jcrSession).getPrincipalManager();
        Principal principal = principalManager.getPrincipal(principalId);
        if (principal == null) {
            throw new RepositoryException("Invalid principalId was submitted.");
        }
        return principal;
    }

    @NotNull
    protected void validateArgs(Session jcrSession, String resourcePath) throws RepositoryException {
        if (jcrSession == null) {
            throw new RepositoryException("JCR Session not found");
        }
        this.validateResourcePath(jcrSession, resourcePath);
    }

    protected void validateResourcePath(Session jcrSession, String resourcePath) throws RepositoryException {
        if (resourcePath == null) {
            throw new ResourceNotFoundException("Resource path was not supplied.");
        }
        if (!jcrSession.nodeExists(resourcePath)) {
            throw new ResourceNotFoundException("Resource is not a JCR Node");
        }
    }

    protected void processACE(Map<String, RestrictionDefinition> srMap, JackrabbitAccessControlEntry jrAccessControlEntry, Privilege[] privileges, Map<Privilege, LocalPrivilege> map) throws RepositoryException {
        boolean isAllow = jrAccessControlEntry.isAllow();
        @NotNull String[] restrictionNames = jrAccessControlEntry.getRestrictionNames();
        HashSet<LocalRestriction> restrictionItems = new HashSet<LocalRestriction>();
        for (String restrictionName : restrictionNames) {
            RestrictionDefinition rd = srMap.get(restrictionName);
            boolean isMulti = rd.getRequiredType().isArray();
            if (isMulti) {
                restrictionItems.add(new LocalRestriction(rd, jrAccessControlEntry.getRestrictions(restrictionName)));
                continue;
            }
            restrictionItems.add(new LocalRestriction(rd, jrAccessControlEntry.getRestriction(restrictionName)));
        }
        if (isAllow) {
            PrivilegesHelper.allow(map, restrictionItems, Arrays.asList(privileges));
        } else {
            PrivilegesHelper.deny(map, restrictionItems, Arrays.asList(privileges));
        }
    }

    @NotNull
    protected Map<String, List<AccessControlEntry>> entriesSortedByEffectivePath(@NotNull AccessControlPolicy[] policies, @NotNull Predicate<? super AccessControlEntry> accessControlEntryFilter, Map<Principal, Map<DeclarationType, Set<String>>> declaredAtPaths) throws RepositoryException {
        Comparator effectivePathComparator = (k1, k2) -> Objects.compare(k1, k2, Comparator.nullsFirst(String::compareTo));
        TreeMap<String, List<AccessControlEntry>> effectivePathToEntriesMap = new TreeMap<String, List<AccessControlEntry>>(effectivePathComparator);
        for (AccessControlPolicy accessControlPolicy : policies) {
            AccessControlEntry[] accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
            if (!(accessControlPolicy instanceof AccessControlList)) continue;
            Stream.of(accessControlEntries).filter(accessControlEntryFilter).forEach(entry -> {
                DeclarationType dt = null;
                String effectivePath = null;
                if (entry instanceof PrincipalAccessControlList.Entry) {
                    PrincipalAccessControlList.Entry paclEntry = (PrincipalAccessControlList.Entry)entry;
                    effectivePath = paclEntry.getEffectivePath();
                    if (effectivePath == null) {
                        effectivePath = "/:repository";
                    }
                    dt = DeclarationType.PRINCIPAL;
                } else if (accessControlPolicy instanceof JackrabbitAccessControlList) {
                    JackrabbitAccessControlList jacList = (JackrabbitAccessControlList)accessControlPolicy;
                    effectivePath = jacList.getPath();
                    dt = DeclarationType.NODE;
                }
                List entriesForPath = effectivePathToEntriesMap.computeIfAbsent(effectivePath, key -> new ArrayList());
                entriesForPath.add(entry);
                Map map = declaredAtPaths.computeIfAbsent(entry.getPrincipal(), k -> new HashMap());
                Set set = map.computeIfAbsent(dt, k -> new HashSet());
                set.add(effectivePath);
            });
        }
        return effectivePathToEntriesMap;
    }
}

