/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.scriptable;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.junit.scriptable.HttpRequest;
import org.apache.sling.junit.scriptable.HttpResponse;
import org.apache.sling.junit.scriptable.ScriptableTestsProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestAllPaths {
    private final String path;
    public static final String TEST_URL_SUFFIX = ".test.txt";
    public static final String PASSED = "TEST_PASSED";

    public TestAllPaths(String path) {
        this.path = path;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (String path : ScriptableTestsProvider.getTestContext().testPaths) {
            data.add(new Object[]{path + TEST_URL_SUFFIX});
        }
        return data;
    }

    @Test
    public void verifyContent() throws Exception {
        ScriptableTestsProvider.TestContext ctx = ScriptableTestsProvider.getTestContext();
        HttpRequest req = new HttpRequest(this.path);
        HttpResponse resp = new HttpResponse();
        ctx.requestProcessor.processRequest((HttpServletRequest)req, (HttpServletResponse)resp, ctx.resourceResolver);
        String content = resp.getContent();
        Assert.assertEquals((String)("Expecting HTTP status 200 for path " + this.path), (long)200L, (long)resp.getStatus());
        boolean testSuccess = TestAllPaths.checkTest(content);
        if (!testSuccess) {
            Assert.fail((String)("Unexpected content at path " + this.path + ", should be just " + PASSED + " (lines starting with # and empty lines are ignored)\ncontent was:\n" + content + "\n"));
        }
    }

    public static boolean checkTest(String content) throws Exception {
        BufferedReader br = new BufferedReader(new StringReader(content));
        String line = null;
        int passedCount = 0;
        while ((line = br.readLine()) != null) {
            if (line.trim().length() == 0 || line.startsWith("#")) continue;
            if (line.trim().equals(PASSED) && passedCount == 0) {
                ++passedCount;
                continue;
            }
            return false;
        }
        return passedCount != 0;
    }
}

