/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.inventory.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.json.Json;
import javax.json.JsonValue;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.resource.inventory.impl.ResourceTraversor;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={InventoryPrinter.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"felix.inventory.printer.format=JSON", "felix.inventory.printer.webconsole:Boolean=false"})
@Designate(ocd=Config.class, factory=true)
public class ResourceInventoryPrinterFactory
implements InventoryPrinter {
    private String path;
    @Reference
    private ResourceResolverFactory factory;

    @Activate
    protected void activate(Config config) {
        this.path = config.path();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintWriter printWriter, Format format, boolean isZip) {
        if (this.path == null || !format.equals(Format.JSON)) {
            return;
        }
        try (ResourceResolver resolver = null;){
            resolver = this.factory.getAdministrativeResourceResolver(null);
            Resource rootResource = resolver.getResource(this.path);
            if (rootResource != null) {
                ResourceTraversor rt = new ResourceTraversor(rootResource);
                rt.collectResources();
                StringWriter writer = new StringWriter();
                Json.createGenerator((Writer)writer).write((JsonValue)rt.getJsonObject()).close();
                printWriter.write(writer.toString());
            }
        }
    }

    @ObjectClassDefinition(name="Apache Sling Resource Inventory Printer Factory", description="This factory can be used to add resource trees to the inventory of the system.")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="The unique name of the inventory printer.")
        public String felix_inventory_printer_name();

        @AttributeDefinition(name="Title", description="The title of the inventory printer.")
        public String felix_inventory_printer_title();

        @AttributeDefinition(name="Path", description="The resource path to include.")
        public String path() default "";
    }
}

