/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.util.Arrays;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.apache.sling.testing.mock.sling.MockSling;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletRequest;
import org.apache.sling.testing.mock.sling.servlet.MockSlingHttpServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;

public class MockSlingScriptHelperTest {
    private ResourceResolver resourceResolver;
    private SlingHttpServletRequest request;
    private SlingHttpServletResponse response;
    private BundleContext bundleContext;
    private SlingScriptHelper scriptHelper;

    @Before
    public void setUp() throws Exception {
        this.bundleContext = MockOsgi.newBundleContext();
        this.resourceResolver = MockSling.newResourceResolver((BundleContext)this.bundleContext);
        this.request = new MockSlingHttpServletRequest(this.resourceResolver, this.bundleContext);
        this.response = new MockSlingHttpServletResponse();
        this.scriptHelper = MockSling.newSlingScriptHelper((SlingHttpServletRequest)this.request, (SlingHttpServletResponse)this.response, (BundleContext)this.bundleContext);
    }

    @After
    public void tearDown() {
        this.resourceResolver.close();
        MockOsgi.shutdown((BundleContext)this.bundleContext);
    }

    @Test
    public void testRequest() {
        Assert.assertSame((Object)this.request, (Object)this.scriptHelper.getRequest());
    }

    @Test
    public void testResponse() {
        Assert.assertSame((Object)this.response, (Object)this.scriptHelper.getResponse());
    }

    @Test
    public void testGetService() {
        this.bundleContext.registerService(String.class.getName(), (Object)"test", null);
        Assert.assertEquals((Object)"test", (Object)this.scriptHelper.getService(String.class));
    }

    @Test
    public void testGetServices() {
        Object[] services;
        for (Integer n : services = new Integer[]{1, 2, 3}) {
            this.bundleContext.registerService(Integer.class.getName(), (Object)n, null);
        }
        Object[] servicesResult = (Integer[])this.scriptHelper.getServices(Integer.class, null);
        Arrays.sort(servicesResult);
        Assert.assertArrayEquals((Object[])services, (Object[])servicesResult);
    }
}

