/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table.fill;

import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;

public class FillColumn
implements JRPropertiesHolder {
    private BaseColumn tableColumn;
    private int width;
    private List<FillColumn> subcolumns;
    private final Integer defaultWeight;
    private int subColsTotalWeight;
    private Integer colSpan;
    private JRPropertiesMap properties;

    public FillColumn(Column column, Integer defaultWeight, JRPropertiesMap properties) {
        this(column, column.getWidth(), null, 0, defaultWeight, properties);
    }

    public FillColumn(ColumnGroup columnGroup, int width, List<FillColumn> subcolumns, int subColsTotalWeight, JRPropertiesMap properties) {
        this(columnGroup, width, subcolumns, subColsTotalWeight, null, properties);
    }

    private FillColumn(BaseColumn tableColumn, int width, List<FillColumn> subcolumns, int subColsTotalWeight, Integer defaultWeight, JRPropertiesMap properties) {
        this.tableColumn = tableColumn;
        this.width = width;
        this.subcolumns = subcolumns;
        this.subColsTotalWeight = subColsTotalWeight;
        this.defaultWeight = defaultWeight;
        this.properties = properties;
    }

    public BaseColumn getTableColumn() {
        return this.tableColumn;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWeight() {
        return this.tableColumn.getWeight() == null ? (this.defaultWeight == null ? this.subColsTotalWeight : this.defaultWeight) : this.tableColumn.getWeight();
    }

    public int getSubColsTotalWeight() {
        return this.subColsTotalWeight;
    }

    public int getColSpan() {
        if (this.colSpan == null) {
            this.colSpan = 1;
            if (this.subcolumns != null && this.subcolumns.size() > 0) {
                this.colSpan = 0;
                for (FillColumn subcolumn : this.subcolumns) {
                    this.colSpan = this.colSpan + subcolumn.getColSpan();
                }
            }
        }
        return this.colSpan;
    }

    public List<FillColumn> getSubcolumns() {
        return this.subcolumns;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FillColumn)) {
            return false;
        }
        FillColumn col = (FillColumn)obj;
        return this.tableColumn == col.tableColumn && this.width == col.width && (this.subcolumns == null ? col.subcolumns == null : col.subcolumns != null && this.subcolumns.equals(col.subcolumns));
    }

    public int hashCode() {
        int hash = this.tableColumn.hashCode();
        hash = hash * 37 + this.width;
        hash = hash * 37 + (this.subcolumns == null ? 0 : this.subcolumns.hashCode());
        return hash;
    }

    @Override
    public boolean hasProperties() {
        return this.properties != null && this.properties.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        return this.properties;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }
}

