/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractMarkAction;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaAnnotation;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkAction
extends AbstractMarkAction {
    protected final NumberExpression score;
    protected final List<NumberExpression> list;

    public MarkAction(TypeExpression type, NumberExpression scoreValue, List<NumberExpression> list) {
        super(type);
        this.score = scoreValue;
        this.list = list;
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        List<Integer> indexList = this.getIndexList(element, this.list);
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotations(stream, indexList, element.getContainer());
        for (AnnotationFS matchedAnnotation : matchedAnnotations) {
            if (matchedAnnotation == null) {
                return;
            }
            if (this.score == null) {
                this.createAnnotation(matchedAnnotation, element, stream, match);
                continue;
            }
            double deltaScore = this.score.getDoubleValue(element.getParent());
            this.updateHeuristicAnnotation(match, element, stream, matchedAnnotation, deltaScore);
        }
    }

    protected void updateHeuristicAnnotation(RuleMatch match, RuleElement element, RutaStream stream, AnnotationFS matchedAnnotation, double deltaScore) {
        Type heuristicType = stream.getJCas().getCasType(RutaAnnotation.type);
        RutaAnnotation heuristicAnnotation = (RutaAnnotation)stream.getCas().createAnnotation(heuristicType, matchedAnnotation.getBegin(), matchedAnnotation.getEnd());
        Annotation newAnnotation = (Annotation)stream.getCas().createAnnotation(this.type.getType(element.getParent()), heuristicAnnotation.getBegin(), heuristicAnnotation.getEnd());
        heuristicAnnotation.setScore(deltaScore);
        heuristicAnnotation.setAnnotation(newAnnotation);
        List<AnnotationFS> annotationsInWindow = stream.getAnnotationsInWindow((AnnotationFS)heuristicAnnotation, heuristicType);
        if (annotationsInWindow.isEmpty()) {
            heuristicAnnotation.addToIndexes();
            newAnnotation.addToIndexes();
            stream.addAnnotation((AnnotationFS)newAnnotation, match);
        } else {
            RutaAnnotation tma = stream.getCorrectTMA(annotationsInWindow, heuristicAnnotation);
            if (tma != null) {
                tma.removeFromIndexes();
                double newScore = tma.getScore() + deltaScore;
                tma.setScore(newScore);
                tma.addToIndexes();
            } else {
                heuristicAnnotation.addToIndexes();
                newAnnotation.addToIndexes();
                stream.addAnnotation((AnnotationFS)newAnnotation, match);
            }
        }
    }

    public NumberExpression getScore() {
        return this.score;
    }

    public List<NumberExpression> getList() {
        return this.list;
    }
}

