/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.whisk.generic;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.ruta.textruler.core.TextRulerAnnotation;
import org.apache.uima.ruta.textruler.core.TextRulerRule;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.core.TextRulerWordConstraint;
import org.apache.uima.ruta.textruler.learner.whisk.generic.WhiskRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhiskRuleItem
implements TextRulerRuleItem {
    private TextRulerWordConstraint wordConstraint;
    private boolean isStarWildCard = false;
    private boolean hideRegExp = false;
    protected List<MLWhiskOtherConstraint> otherConstraints = new ArrayList<MLWhiskOtherConstraint>();

    public WhiskRuleItem() {
        this.wordConstraint = null;
    }

    public static WhiskRuleItem newWildCardItem(int startTermNumber) {
        WhiskRuleItem i = new WhiskRuleItem();
        i.setIsStarWildCard(true);
        return i;
    }

    public WhiskRuleItem(WhiskRuleItem copyFrom) {
        if (copyFrom.wordConstraint != null) {
            this.wordConstraint = copyFrom.wordConstraint.copy();
        }
        this.isStarWildCard = copyFrom.isStarWildCard;
        this.hideRegExp = copyFrom.hideRegExp;
        for (MLWhiskOtherConstraint c : copyFrom.otherConstraints) {
            this.otherConstraints.add(c.copy());
        }
    }

    public WhiskRuleItem(TextRulerAnnotation tokenAnnotation) {
        this.setWordConstraint(new TextRulerWordConstraint(tokenAnnotation));
    }

    public void setWordConstraint(TextRulerWordConstraint c) {
        this.wordConstraint = c;
    }

    public TextRulerWordConstraint getWordConstraint() {
        return this.wordConstraint;
    }

    @Override
    public TextRulerRuleItem copy() {
        return new WhiskRuleItem(this);
    }

    @Override
    public String getStringForRuleString(TextRulerRule rule, TextRulerRuleItem.MLRuleItemType type, int numberInPattern, int patternSize, int numberInRule, int ruleSize, int slotIndex) {
        String result = "";
        WhiskRule whiskRule = (WhiskRule)rule;
        boolean isMarkingItem = type == TextRulerRuleItem.MLRuleItemType.FILLER && numberInPattern == 0;
        ArrayList<String> constraints = new ArrayList<String>();
        String anchor = null;
        if (this.wordConstraint != null) {
            if (this.wordConstraint.isRegExpConstraint()) {
                anchor = this.wordConstraint.typeShortName();
                if (!this.hideRegExp) {
                    constraints.add("REGEXP(\"" + this.wordConstraint + "\")");
                }
            } else {
                anchor = this.wordConstraint.toString();
            }
        }
        MLWhiskOtherConstraint anchorConstraint = null;
        if (anchor == null) {
            for (MLWhiskOtherConstraint c : this.otherConstraints) {
                if (!c.canBeAnchorConstraint()) continue;
                anchorConstraint = c;
                break;
            }
        }
        for (MLWhiskOtherConstraint oc : this.otherConstraints) {
            if (oc == anchorConstraint) continue;
            if (oc.canBeAnchorConstraint()) {
                constraints.add("IS(" + oc + ")");
                continue;
            }
            constraints.add("PARTOF(" + oc + ")");
        }
        if (anchor == null) {
            anchor = anchorConstraint != null ? anchorConstraint.toString() : "ALL";
        }
        if (constraints.size() > 0) {
            String cStr = "";
            for (String constraintStr : constraints) {
                if (cStr.length() > 0) {
                    cStr = cStr + ", ";
                }
                cStr = cStr + constraintStr;
            }
            result = result + "{" + cStr;
            if (!isMarkingItem) {
                result = result + "}";
            }
        }
        if (isMarkingItem) {
            if (constraints.size() == 0) {
                result = result + "{";
            }
            result = result + "->MARKONCE(" + whiskRule.getMarkName(slotIndex);
            if (patternSize > 1) {
                result = result + ", " + (numberInRule + 1) + ", " + (numberInRule + patternSize);
            }
            result = result + ")}";
        }
        if (this.isStarWildCard) {
            anchor = anchor + "*?";
        }
        return anchor + result;
    }

    public void setIsStarWildCard(boolean flag) {
        this.isStarWildCard = flag;
    }

    public boolean isStarWildCard() {
        return this.isStarWildCard;
    }

    @Override
    public boolean equals(TextRulerRuleItem o) {
        WhiskRuleItem it = (WhiskRuleItem)o;
        if (this.wordConstraint != null && !this.wordConstraint.equals(it.wordConstraint)) {
            return false;
        }
        return this.isStarWildCard == it.isStarWildCard;
    }

    @Override
    public String toString() {
        return this.getStringForRuleString(null, null, 0, 0, 0, 0, 0);
    }

    public void setHideRegExp(boolean flag) {
        this.hideRegExp = flag;
    }

    public void addOtherConstraint(MLWhiskOtherConstraint c) {
        if (!this.otherConstraints.contains(c)) {
            this.otherConstraints.add(c);
        }
    }

    public List<MLWhiskOtherConstraint> getOtherConstraints() {
        return this.otherConstraints;
    }

    public int constraintPoints() {
        int result = 0;
        if (this.wordConstraint != null) {
            result += this.hideRegExp ? 1 : 3;
        }
        return result += this.otherConstraints.size();
    }

    public static class MLWhiskOtherConstraint {
        TextRulerAnnotation tokenAnnotation;
        TextRulerAnnotation constraintAnnotation;
        boolean canBeAnchor;
        Type type;

        public MLWhiskOtherConstraint(TextRulerAnnotation tokenAnnotation, TextRulerAnnotation constraintAnnotation) {
            this.tokenAnnotation = tokenAnnotation;
            this.constraintAnnotation = constraintAnnotation;
            this.type = constraintAnnotation.getType();
            this.canBeAnchor = tokenAnnotation.getBegin() == constraintAnnotation.getBegin() && tokenAnnotation.getEnd() == constraintAnnotation.getEnd();
        }

        public boolean isTMBasicTypeTokenConstraint() {
            return this.tokenAnnotation == this.constraintAnnotation;
        }

        public boolean canBeAnchorConstraint() {
            return this.canBeAnchor;
        }

        public boolean equals(Object o) {
            MLWhiskOtherConstraint co = (MLWhiskOtherConstraint)o;
            return this.toString().equals(co.toString()) && this.canBeAnchor == co.canBeAnchor;
        }

        public int hashCode() {
            return this.toString().hashCode() * (this.canBeAnchor ? 2 : 1);
        }

        public String toString() {
            return this.type.getShortName();
        }

        public MLWhiskOtherConstraint copy() {
            return new MLWhiskOtherConstraint(this.tokenAnnotation, this.constraintAnnotation);
        }
    }
}

