/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.trabal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.ruta.textruler.learner.trabal.Condition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RankedList
extends ArrayList<Condition> {
    private static final long serialVersionUID = -5978107285325156323L;
    Map<Condition, Double> ranking = new HashMap<Condition, Double>();
    Map<String, Double> idf;

    public RankedList(Map<String, Double> i) {
        this.idf = i;
    }

    public RankedList(Collection<? extends Condition> c, Map<String, Double> i) {
        this.idf = i;
        this.addAll(c);
    }

    @Override
    public boolean add(Condition e) {
        boolean result;
        double value = this.idf.containsKey(e.getItem().getAnnotation().getType().getShortName()) ? this.idf.get(e.getItem().getAnnotation().getType().getShortName()) : 1.0;
        if (this.ranking.containsKey(e)) {
            Double rank = this.ranking.get(e);
            rank = new Double(rank + value);
            this.ranking.put(e, rank);
            result = false;
        } else {
            super.add(e);
            this.ranking.put(e, new Double(value));
            result = true;
        }
        return result;
    }

    public void add(double index, Condition e) {
        if (this.ranking.containsKey(e)) {
            Double rank = this.ranking.get(e);
            rank = new Double(rank + index);
            this.ranking.put(e, rank);
        } else {
            super.add(e);
            this.ranking.put(e, new Double(index));
        }
    }

    public void addAll(RankedList list) {
        for (Condition each : list) {
            this.add(list.rankingOf(each), each);
        }
    }

    @Override
    public boolean addAll(Collection<? extends Condition> c) {
        for (Condition condition : c) {
            this.add(condition);
        }
        return true;
    }

    public boolean addAll(double index, Collection<? extends Condition> c) {
        for (Condition condition : c) {
            this.add(index, condition);
        }
        return true;
    }

    @Override
    public Condition remove(int index) {
        Condition element = (Condition)super.get(index);
        if (element != null && this.ranking.containsKey(element)) {
            this.ranking.remove(element);
            super.remove(index);
            return element;
        }
        return null;
    }

    @Override
    public boolean remove(Object o) {
        if (this.size() > 0 && this.contains(o) && this.ranking.containsKey(o)) {
            super.remove(o);
            this.ranking.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public List<Condition> subList(int start, int end) {
        return super.subList(start, end);
    }

    @Override
    public boolean contains(Object o) {
        return super.contains(o);
    }

    @Override
    public void clear() {
        super.clear();
        this.ranking.clear();
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public RankedList clone() {
        RankedList clone = new RankedList(this.idf);
        for (Condition element : this.subList(0, this.size())) {
            clone.add(this.rankingOf(element), element.clone());
        }
        return clone;
    }

    @Override
    public Condition get(int i) {
        return (Condition)super.get(i);
    }

    public double rankingOf(Condition each) {
        if (this.contains(each)) {
            return this.ranking.get(each);
        }
        return 0.0;
    }

    public Map<Condition, Double> getRanking() {
        return this.ranking;
    }

    public void sort() {
        ArrayList<Condition> newList = new ArrayList<Condition>();
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < newList.size(); ++j) {
                if (!(this.ranking.get(this.get(i)) >= this.ranking.get(newList.get(j)))) continue;
                newList.add(j, this.get(i));
                break;
            }
            if (newList.contains(this.get(i))) continue;
            newList.add(this.get(i));
        }
        super.clear();
        super.addAll(newList);
    }

    public RankedList unite(RankedList list) {
        RankedList clone = this.clone();
        for (Condition element : list.subList(0, list.size())) {
            clone.add(list.rankingOf(element), element.clone());
        }
        clone.sort();
        return clone;
    }

    public RankedList cut(RankedList list) {
        RankedList clone = this.clone();
        for (Condition element : this.subList(0, this.size())) {
            if (list.contains(element)) {
                clone.add(list.rankingOf(element), element.clone());
                continue;
            }
            clone.remove(element);
        }
        clone.sort();
        return clone;
    }

    public RankedList subtract(RankedList list) {
        RankedList clone = this.clone();
        for (Condition element : this.subList(0, this.size())) {
            if (list.contains(element)) {
                clone.remove(element);
                continue;
            }
            clone.add(list.rankingOf(element), element.clone());
        }
        clone.sort();
        return clone;
    }

    @Override
    public Condition set(int index, Condition element) {
        if (this.size() >= index) {
            double value = this.ranking.get(this.get(index));
            if (this.contains(element)) {
                this.ranking.put(element, new Double(this.ranking.get(element) + (double)index));
                super.remove(element);
            } else {
                this.ranking.put(element, value);
            }
            this.ranking.remove(this.get(index));
        }
        return super.set(index, element);
    }

    @Override
    public void add(int index, Condition element) {
        if (this.size() >= index) {
            double value = this.ranking.get(this.get(index));
            if (!this.contains(element)) {
                this.ranking.put(element, value);
                super.add(index, element);
            }
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends Condition> c) {
        if (this.size() >= index) {
            double value = this.ranking.get(this.get(index));
            for (Condition condition : c) {
                if (this.contains(condition)) continue;
                this.ranking.put(condition, value);
                super.add(index, condition);
                return true;
            }
        }
        return false;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            this.ranking.remove(this.get(i));
        }
        super.removeRange(fromIndex, toIndex);
    }
}

