/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.generate;

import java.io.File;
import java.util.ArrayList;
import org.apache.uima.pear.PearPlugin;
import org.apache.uima.pear.generate.PearExportMessages;
import org.apache.uima.pear.generate.PearExportOperation;
import org.apache.uima.pear.insd.edit.InsdConstants;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class PearFileResourceExportPage
extends WizardPage
implements InsdConstants {
    protected static final String PEAR_FILE = "pear_file";
    protected final IPreferenceStore fPreferenceStore;
    protected final IContainer fCurrentContainer;
    protected final IStructuredSelection fSelection;
    protected ContainerCheckedTreeViewer fTreeViewer;
    protected Text fDestinationFileInput;
    protected Button fCompressCheckbox;

    public PearFileResourceExportPage(IStructuredSelection selection, IContainer currentContainer) {
        super("pearFileResourceExportPage");
        PearPlugin plugin = PearPlugin.getDefault();
        this.fPreferenceStore = plugin.getPreferenceStore();
        this.setTitle(PearExportMessages.getString("PearExport.exportTitle"));
        this.setDescription(PearExportMessages.getString("PearExport.description"));
        this.fCurrentContainer = currentContainer;
        this.fSelection = selection;
    }

    protected void pageStateChanged() {
        if (!this.isMetadataIncluded()) {
            this.setErrorMessage(PearExportMessages.getString("PearExport.metadataRequired"));
            this.setPageComplete(false);
            return;
        }
        String filename = this.getDestinationValue();
        if (new File(filename).isDirectory()) {
            this.setErrorMessage(PearExportMessages.getString("PearFileResourceExportPage.DirectorySelected"));
            this.setPageComplete(false);
            return;
        }
        if (filename == null || filename.trim().equals("")) {
            this.setErrorMessage(null);
            this.setMessage(PearExportMessages.getString("PearFileResourceExportPage.SelectFile"), 1);
            this.setPageComplete(false);
            return;
        }
        if (new File(filename).exists()) {
            this.setErrorMessage(null);
            this.setMessage(PearExportMessages.format(PearExportMessages.getString("PearFileResourceExportPage.FileExistsInfo"), new Object[]{filename}), 1);
            this.setPageComplete(true);
            return;
        }
        this.setMessage(null);
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    protected boolean isMetadataIncluded() {
        Object[] grayed = this.fTreeViewer.getGrayedElements();
        if (this.isMetadataIncluded(grayed)) {
            return false;
        }
        Object[] checked = this.fTreeViewer.getCheckedElements();
        return this.isMetadataIncluded(checked);
    }

    private boolean isMetadataIncluded(Object[] checked) {
        for (int i = 0; i < checked.length; ++i) {
            IAdaptable adaptable;
            IResource resource;
            if (!(checked[i] instanceof IAdaptable) || (resource = (IResource)(adaptable = (IAdaptable)checked[i]).getAdapter(IResource.class)) == null || !"metadata".equals(resource.getName())) continue;
            return true;
        }
        return false;
    }

    protected void handleDestinationBrowseButtonPressed() {
        String selectedFileName;
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.pear", "*.*"});
        dialog.setText(PearExportMessages.getString("PearExport.selectDestinationTitle"));
        String destination = this.getDestinationValue();
        int lastDirectoryIndex = destination.lastIndexOf(File.separator);
        if (lastDirectoryIndex != -1) {
            dialog.setFilterPath(destination.substring(0, lastDirectoryIndex));
        }
        if ((selectedFileName = dialog.open()) != null) {
            this.fDestinationFileInput.setText(selectedFileName);
            this.saveDestinationValue(selectedFileName);
        }
    }

    protected void saveDestinationValue(String filename) {
        this.fPreferenceStore.setValue(PEAR_FILE, filename);
        this.fPreferenceStore.needsSaving();
    }

    protected String getDestinationValue() {
        if (this.fDestinationFileInput != null) {
            return this.fDestinationFileInput.getText();
        }
        return this.fPreferenceStore.getString(PEAR_FILE);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createSourceControl(container);
        this.createDestinationControl(container);
        this.createOptionsGroup(container);
        this.pageStateChanged();
        this.setControl((Control)container);
    }

    protected void createOptionsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PearExportMessages.getString("PearFileResourceExportPage.Options"));
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fCompressCheckbox = new Button((Composite)group, 32);
        this.fCompressCheckbox.setSelection(true);
        this.fCompressCheckbox.setText(PearExportMessages.getString("PearFileResourceExportPage.CompressContents"));
    }

    protected void createSourceControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fTreeViewer = this.createTreeViewer(container);
        this.fTreeViewer.setInput((Object)this.fCurrentContainer);
        this.fTreeViewer.setCheckedElements(this.fSelection.toArray());
        this.fTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PearFileResourceExportPage.this.pageStateChanged();
            }
        });
        Composite buttonsComposite = new Composite(container, 0);
        buttonsComposite.setLayout((Layout)new RowLayout(256));
        Button selectAllButton = new Button(buttonsComposite, 8);
        selectAllButton.setText(PearExportMessages.getString("PearFileResourceExportPage.SelectAll"));
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PearFileResourceExportPage.this.setAllChecked(PearFileResourceExportPage.this.fTreeViewer.getTree().getItems(), true);
                PearFileResourceExportPage.this.pageStateChanged();
            }
        });
        Button deselectAllButton = new Button(buttonsComposite, 8);
        deselectAllButton.setText(PearExportMessages.getString("PearFileResourceExportPage.DeselectAll"));
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PearFileResourceExportPage.this.setAllChecked(PearFileResourceExportPage.this.fTreeViewer.getTree().getItems(), false);
                PearFileResourceExportPage.this.pageStateChanged();
            }
        });
    }

    protected void setAllChecked(TreeItem[] items, boolean checked) {
        for (int i = 0; i < items.length; ++i) {
            items[i].setChecked(checked);
            TreeItem[] children = items[i].getItems();
            this.setAllChecked(children, checked);
        }
    }

    protected void createDestinationControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(4, -1, true, false));
        Label toPearFileLabel = new Label(container, 0);
        toPearFileLabel.setText(PearExportMessages.getString("PearExport.destinationLabel"));
        this.fDestinationFileInput = new Text(container, 2048);
        this.fDestinationFileInput.setText(this.fPreferenceStore.getString(PEAR_FILE));
        this.fDestinationFileInput.setLayoutData((Object)new GridData(4, -1, true, false));
        this.fDestinationFileInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PearFileResourceExportPage.this.pageStateChanged();
                PearFileResourceExportPage.this.saveDestinationValue(PearFileResourceExportPage.this.fDestinationFileInput.getText());
            }
        });
        Button destinationBrowseButton = new Button(container, 8);
        destinationBrowseButton.setText(PearExportMessages.getString("PearFileResourceExportPage.Browse"));
        destinationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PearFileResourceExportPage.this.handleDestinationBrowseButtonPressed();
            }
        });
    }

    protected ContainerCheckedTreeViewer createTreeViewer(Composite parent) {
        ContainerCheckedTreeViewer treeViewer = new ContainerCheckedTreeViewer(parent);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 150;
        treeViewer.getTree().setLayoutData((Object)gridData);
        treeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        treeViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        return treeViewer;
    }

    public IRunnableWithProgress getExportRunnable() {
        ArrayList<IResource> files = new ArrayList<IResource>();
        Object[] checked = this.fTreeViewer.getCheckedElements();
        for (int i = 0; i < checked.length; ++i) {
            IAdaptable adaptable;
            IResource resource;
            if (!(checked[i] instanceof IAdaptable) || (resource = (IResource)(adaptable = (IAdaptable)checked[i]).getAdapter(IResource.class)) == null || resource.getType() != 1) continue;
            files.add(resource);
        }
        IFile[] exports = new IFile[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            exports[i] = (IFile)files.get(i);
        }
        return new PearExportOperation(exports, this.fCurrentContainer, this.getDestinationValue(), this.fCompressCheckbox.getSelection());
    }
}

