/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LazyExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TailCallReturner;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public class LetExpression
extends Assignation
implements TailCallReturner {
    int refCount;
    int evaluationMode = -1;

    public void setIndexedVariable() {
        this.refCount = 10000;
    }

    public boolean isIndexedVariable() {
        return this.refCount == 10000;
    }

    public int getNominalReferenceCount() {
        return this.refCount;
    }

    public void addReference(VariableReference variableReference) {
        if (this.declaration != null) {
            this.declaration.getReferenceList().add(variableReference);
        } else {
            ++this.refCount;
        }
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.declaration == null) {
            return this;
        }
        this.sequence = this.sequence.typeCheck(staticContext, itemType);
        RoleLocator roleLocator = new RoleLocator(3, new Integer(this.nameCode), 0, staticContext.getNamePool());
        roleLocator.setSourceLocator(this);
        this.sequence = TypeChecker.strictTypeCheck(this.sequence, this.declaration.getRequiredType(), roleLocator, staticContext);
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        ItemType itemType2 = this.sequence.getItemType(typeHierarchy);
        this.declaration.refineTypeInformation(itemType2, this.sequence.getCardinality(), this.sequence instanceof Literal ? ((Literal)this.sequence).getValue() : null, this.sequence.getSpecialProperties(), staticContext);
        this.action = this.action.typeCheck(staticContext, itemType);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression;
        if (this.action instanceof VariableReference && ((VariableReference)this.action).getBinding() == this) {
            return this.sequence.optimize(optimizer, staticContext, itemType);
        }
        if (this.declaration != null) {
            if (this.sequence instanceof DocumentInstr && ((DocumentInstr)this.sequence).isTextOnly() && this.declaration.allReferencesAreAtomized()) {
                this.sequence = ((DocumentInstr)this.sequence).getStringValueExpression(staticContext);
                this.adoptChildExpression(this.sequence);
            }
            if (!this.isIndexedVariable()) {
                this.refCount = this.declaration.getReferenceCount(this, staticContext);
            }
            if (this.refCount == 0) {
                Expression expression2 = this.action.optimize(optimizer, staticContext, itemType);
                expression2.setParentExpression(this.getParentExpression());
                return expression2;
            }
            if (this.refCount == 1) {
                this.replaceVariable(optimizer, this.sequence);
                return this.action.optimize(optimizer, staticContext, itemType);
            }
            this.declaration = null;
        }
        int n = 0;
        while (n++ < 5 && (expression = this.sequence.optimize(optimizer, staticContext, itemType)) != this.sequence) {
            this.sequence = expression;
            this.adoptChildExpression(this.sequence);
            this.resetStaticProperties();
        }
        n = 0;
        while (n++ < 5 && (expression = this.action.optimize(optimizer, staticContext, itemType)) != this.action) {
            this.action = expression;
            this.adoptChildExpression(this.action);
            this.resetStaticProperties();
        }
        expression = this.promoteWhereClause(null);
        if (expression != null) {
            return expression;
        }
        this.evaluationMode = ExpressionTool.lazyEvaluationMode(this.sequence);
        return this;
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        this.action.checkPermittedContents(schemaType, staticContext, bl);
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        LetExpression letExpression = this;
        while (true) {
            ValueRepresentation valueRepresentation = letExpression.eval(xPathContext);
            xPathContext.setLocalVariable(letExpression.slotNumber, valueRepresentation);
            if (!(letExpression.action instanceof LetExpression)) break;
            letExpression = (LetExpression)letExpression.action;
        }
        return letExpression.action.iterate(xPathContext);
    }

    protected ValueRepresentation eval(XPathContext xPathContext) throws XPathException {
        if (this.evaluationMode == -1) {
            this.evaluationMode = ExpressionTool.lazyEvaluationMode(this.sequence);
        }
        return ExpressionTool.evaluate(this.sequence, this.evaluationMode, xPathContext, this.refCount);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        LetExpression letExpression = this;
        while (true) {
            ValueRepresentation valueRepresentation = letExpression.eval(xPathContext);
            xPathContext.setLocalVariable(letExpression.slotNumber, valueRepresentation);
            if (!(letExpression.action instanceof LetExpression)) break;
            letExpression = (LetExpression)letExpression.action;
        }
        return letExpression.action.evaluateItem(xPathContext);
    }

    public void process(XPathContext xPathContext) throws XPathException {
        LetExpression letExpression = this;
        while (true) {
            ValueRepresentation valueRepresentation = letExpression.eval(xPathContext);
            xPathContext.setLocalVariable(letExpression.slotNumber, valueRepresentation);
            if (!(letExpression.action instanceof LetExpression)) break;
            letExpression = (LetExpression)letExpression.action;
        }
        letExpression.action.process(xPathContext);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.action.getItemType(typeHierarchy);
    }

    public int computeCardinality() {
        return this.action.getCardinality();
    }

    public int computeSpecialProperties() {
        int n = this.action.getSpecialProperties();
        int n2 = this.sequence.getSpecialProperties();
        if ((n2 & 0x400000) == 0) {
            n &= 0xFFBFFFFF;
        }
        return n;
    }

    public int markTailFunctionCalls(int n, int n2) {
        return ExpressionTool.markTailFunctionCalls(this.action, n, n2);
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.sequence = this.doPromotion(this.sequence, promotionOffer);
        if (promotionOffer.action == 12 || promotionOffer.action == 13 || promotionOffer.action == 14) {
            this.action = this.doPromotion(this.action, promotionOffer);
        } else if (promotionOffer.action == 11) {
            Binding[] bindingArray = promotionOffer.bindingList;
            Binding[] bindingArray2 = new Binding[promotionOffer.bindingList.length + 1];
            System.arraycopy(promotionOffer.bindingList, 0, bindingArray2, 0, promotionOffer.bindingList.length);
            bindingArray2[promotionOffer.bindingList.length] = this;
            promotionOffer.bindingList = bindingArray2;
            this.action = this.doPromotion(this.action, promotionOffer);
            promotionOffer.bindingList = bindingArray;
        }
        if (this.sequence instanceof VariableReference) {
            this.replaceVariable(promotionOffer.getOptimizer(), this.sequence);
            return this.action;
        }
        if (this.sequence instanceof LazyExpression && ((LazyExpression)this.sequence).getBaseExpression() instanceof VariableReference) {
            this.replaceVariable(promotionOffer.getOptimizer(), ((LazyExpression)this.sequence).getBaseExpression());
            return this.action;
        }
        return this;
    }

    private void replaceVariable(Optimizer optimizer, Expression expression) throws XPathException {
        Binding binding;
        PromotionOffer promotionOffer = new PromotionOffer(optimizer);
        promotionOffer.action = 12;
        Binding[] bindingArray = new Binding[]{this};
        promotionOffer.bindingList = bindingArray;
        promotionOffer.containingExpression = expression;
        this.action = this.doPromotion(this.action, promotionOffer);
        if (promotionOffer.accepted) {
            promotionOffer.accepted = false;
            this.replaceVariable(optimizer, expression);
        }
        if (this.isIndexedVariable() && (binding = ((VariableReference)expression).getBinding()) instanceof LetExpression) {
            ((LetExpression)binding).setIndexedVariable();
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        LetExpression letExpression = this;
        while (true) {
            ValueRepresentation valueRepresentation = letExpression.eval(xPathContext);
            xPathContext.setLocalVariable(letExpression.slotNumber, valueRepresentation);
            if (!(letExpression.action instanceof LetExpression)) break;
            letExpression = (LetExpression)letExpression.action;
        }
        if (letExpression.action instanceof TailCallReturner) {
            return ((TailCallReturner)((Object)letExpression.action)).processLeavingTail(xPathContext);
        }
        letExpression.action.process(xPathContext);
        return null;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "let $" + this.getVariableName() + (this.isIndexedVariable() ? " [indexed]" : " [refCount=" + this.refCount + "]") + " as " + this.sequence.getItemType(configuration.getTypeHierarchy()).toString(configuration.getNamePool()) + Cardinality.getOccurrenceIndicator(this.sequence.getCardinality()) + " :=");
        this.sequence.display(n + 1, printStream, configuration);
        printStream.println(ExpressionTool.indent(n) + "return");
        this.action.display(n + 1, printStream, configuration);
    }
}

