﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/config/ConfigService_EXPORTS.h>
#include <aws/config/model/Compliance.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ConfigService {
namespace Model {

/**
 * <p>Indicates whether an Config rule is compliant based on account ID, region,
 * compliance, and rule name.</p> <p>A rule is compliant if all of the resources
 * that the rule evaluated comply with it. It is noncompliant if any of these
 * resources do not comply.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/AggregateComplianceByConfigRule">AWS
 * API Reference</a></p>
 */
class AggregateComplianceByConfigRule {
 public:
  AWS_CONFIGSERVICE_API AggregateComplianceByConfigRule() = default;
  AWS_CONFIGSERVICE_API AggregateComplianceByConfigRule(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONFIGSERVICE_API AggregateComplianceByConfigRule& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONFIGSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the Config rule.</p>
   */
  inline const Aws::String& GetConfigRuleName() const { return m_configRuleName; }
  inline bool ConfigRuleNameHasBeenSet() const { return m_configRuleNameHasBeenSet; }
  template <typename ConfigRuleNameT = Aws::String>
  void SetConfigRuleName(ConfigRuleNameT&& value) {
    m_configRuleNameHasBeenSet = true;
    m_configRuleName = std::forward<ConfigRuleNameT>(value);
  }
  template <typename ConfigRuleNameT = Aws::String>
  AggregateComplianceByConfigRule& WithConfigRuleName(ConfigRuleNameT&& value) {
    SetConfigRuleName(std::forward<ConfigRuleNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether an Amazon Web Services resource or Config rule is compliant
   * and provides the number of contributors that affect the compliance.</p>
   */
  inline const Compliance& GetCompliance() const { return m_compliance; }
  inline bool ComplianceHasBeenSet() const { return m_complianceHasBeenSet; }
  template <typename ComplianceT = Compliance>
  void SetCompliance(ComplianceT&& value) {
    m_complianceHasBeenSet = true;
    m_compliance = std::forward<ComplianceT>(value);
  }
  template <typename ComplianceT = Compliance>
  AggregateComplianceByConfigRule& WithCompliance(ComplianceT&& value) {
    SetCompliance(std::forward<ComplianceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The 12-digit account ID of the source account.</p>
   */
  inline const Aws::String& GetAccountId() const { return m_accountId; }
  inline bool AccountIdHasBeenSet() const { return m_accountIdHasBeenSet; }
  template <typename AccountIdT = Aws::String>
  void SetAccountId(AccountIdT&& value) {
    m_accountIdHasBeenSet = true;
    m_accountId = std::forward<AccountIdT>(value);
  }
  template <typename AccountIdT = Aws::String>
  AggregateComplianceByConfigRule& WithAccountId(AccountIdT&& value) {
    SetAccountId(std::forward<AccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The source region from where the data is aggregated.</p>
   */
  inline const Aws::String& GetAwsRegion() const { return m_awsRegion; }
  inline bool AwsRegionHasBeenSet() const { return m_awsRegionHasBeenSet; }
  template <typename AwsRegionT = Aws::String>
  void SetAwsRegion(AwsRegionT&& value) {
    m_awsRegionHasBeenSet = true;
    m_awsRegion = std::forward<AwsRegionT>(value);
  }
  template <typename AwsRegionT = Aws::String>
  AggregateComplianceByConfigRule& WithAwsRegion(AwsRegionT&& value) {
    SetAwsRegion(std::forward<AwsRegionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_configRuleName;

  Compliance m_compliance;

  Aws::String m_accountId;

  Aws::String m_awsRegion;
  bool m_configRuleNameHasBeenSet = false;
  bool m_complianceHasBeenSet = false;
  bool m_accountIdHasBeenSet = false;
  bool m_awsRegionHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConfigService
}  // namespace Aws
