/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.ByteArrayOutputStream;
import org.jruby.RubyModule;
import org.jruby.api.Access;
import org.jruby.compiler.Compilable;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.persistence.IRDumper;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class InterpretedIRBlockBody
extends IRBlockBody
implements Compilable<InterpreterContext> {
    private static final Logger LOG = LoggerFactory.getLogger(InterpretedIRBlockBody.class);
    protected final boolean pushScope;
    protected final boolean reuseParentScope;
    private boolean displayedCFG = false;
    private int callCount = 0;
    private InterpreterContext interpreterContext;
    private InterpreterContext fullInterpreterContext;
    private final IRClosure closure;

    public InterpretedIRBlockBody(IRClosure closure, Signature signature) {
        super(closure, signature);
        this.pushScope = true;
        this.reuseParentScope = false;
        this.closure = closure;
        if (closure.getManager().getInstanceConfig().getJitThreshold() == -1) {
            this.setCallCount(-1);
        }
    }

    @Override
    public void setCallCount(int callCount) {
        this.callCount = callCount;
    }

    @Override
    public void completeBuild(ThreadContext context, InterpreterContext interpreterContext) {
        this.fullInterpreterContext = interpreterContext;
        this.displayedCFG = false;
    }

    @Override
    public IRScope getIRScope() {
        return this.closure;
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.closure.getArgumentDescriptors();
    }

    @Override
    public InterpreterContext ensureInstrsReady() {
        InterpreterContext ic;
        if (IRRuntimeHelpers.isDebug() && !this.displayedCFG) {
            LOG.info("Executing '" + String.valueOf(this.closure) + "' (pushScope=" + this.pushScope + ", reuseParentScope=" + this.reuseParentScope, new Object[0]);
            LOG.info(this.closure.debugOutput(), new Object[0]);
            this.displayedCFG = true;
        }
        if ((ic = this.interpreterContext) == null) {
            if (IRRuntimeHelpers.shouldPrintIR(this.closure.getStaticScope().getModule().getRuntime()) && IRRuntimeHelpers.shouldPrintScope(this.getIRScope())) {
                ByteArrayOutputStream baos = IRDumper.printIR(this.closure, false);
                LOG.info("Printing simple IR for " + this.closure.getId() + ":\n" + new String(baos.toByteArray()), new Object[0]);
            }
            this.interpreterContext = ic = this.closure.getInterpreterContext();
        }
        return ic;
    }

    @Override
    public String getOwnerName(ThreadContext context) {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public boolean canCallDirect() {
        return this.fullInterpreterContext != null && this.fullInterpreterContext.hasExplicitCallProtocol();
    }

    @Override
    protected IRubyObject callDirect(ThreadContext context, Block block, IRubyObject[] args2, Block blockArg) {
        this.ensureInstrsReady();
        return Interpreter.INTERPRET_BLOCK(context, block, null, this.fullInterpreterContext, args2, block.getBinding().getMethod(), blockArg);
    }

    @Override
    protected IRubyObject yieldDirect(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
        this.ensureInstrsReady();
        return Interpreter.INTERPRET_BLOCK(context, block, self2, this.fullInterpreterContext, args2, block.getBinding().getMethod(), Block.NULL_BLOCK);
    }

    private static void tryJIT(InterpretedIRBlockBody body, ThreadContext context) {
        if (body.callCount >= 0 && (!context.runtime.isBooting() || Options.JIT_KERNEL.load().booleanValue()) && body.callCount++ >= Access.instanceConfig(context).getJitThreshold()) {
            body.promoteToFullBuild(context, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject commonYieldPath(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2, Block blockArg) {
        InterpretedIRBlockBody.tryJIT(this, context);
        InterpreterContext ic = this.ensureInstrsReady();
        Binding binding2 = block.getBinding();
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame prevFrame = context.preYieldNoScope(binding2);
        DynamicScope actualScope = binding2.getDynamicScope();
        if (ic.pushNewDynScope()) {
            context.pushScope(block.allocScope(actualScope));
        } else if (ic.reuseParentDynScope()) {
            context.pushScope(actualScope);
        }
        self2 = IRRuntimeHelpers.updateBlockState(block, self2);
        try {
            IRubyObject iRubyObject = Interpreter.INTERPRET_BLOCK(context, block, self2, ic, args2, binding2.getMethod(), blockArg);
            return iRubyObject;
        }
        finally {
            InterpretedIRBlockBody.postYield(context, ic, binding2, oldVis, prevFrame);
        }
    }

    @Override
    public boolean forceBuild(ThreadContext context) {
        this.promoteToFullBuild(context, true);
        return true;
    }

    @Override
    public boolean isBuildComplete() {
        return this.callCount < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promoteToFullBuild(ThreadContext context, boolean force) {
        InterpretedIRBlockBody interpretedIRBlockBody = this;
        synchronized (interpretedIRBlockBody) {
            if (this.callCount >= 0) {
                this.callCount = Integer.MIN_VALUE;
                context.runtime.getJITCompiler().buildThresholdReached(context, this, force);
            }
        }
    }

    @Override
    public RubyModule getImplementationClass() {
        return this.closure.getStaticScope().getModule();
    }

    @Override
    public IRClosure getScope() {
        return this.closure;
    }
}

