﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/elasticmapreduce/EMR_EXPORTS.h>
#include <aws/elasticmapreduce/model/FailureDetails.h>
#include <aws/elasticmapreduce/model/StepState.h>
#include <aws/elasticmapreduce/model/StepStateChangeReason.h>
#include <aws/elasticmapreduce/model/StepTimeline.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace EMR {
namespace Model {

/**
 * <p>The execution status details of the cluster step.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/StepStatus">AWS
 * API Reference</a></p>
 */
class StepStatus {
 public:
  AWS_EMR_API StepStatus() = default;
  AWS_EMR_API StepStatus(Aws::Utils::Json::JsonView jsonValue);
  AWS_EMR_API StepStatus& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_EMR_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The execution state of the cluster step.</p>
   */
  inline StepState GetState() const { return m_state; }
  inline bool StateHasBeenSet() const { return m_stateHasBeenSet; }
  inline void SetState(StepState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline StepStatus& WithState(StepState value) {
    SetState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The reason for the step execution status change.</p>
   */
  inline const StepStateChangeReason& GetStateChangeReason() const { return m_stateChangeReason; }
  inline bool StateChangeReasonHasBeenSet() const { return m_stateChangeReasonHasBeenSet; }
  template <typename StateChangeReasonT = StepStateChangeReason>
  void SetStateChangeReason(StateChangeReasonT&& value) {
    m_stateChangeReasonHasBeenSet = true;
    m_stateChangeReason = std::forward<StateChangeReasonT>(value);
  }
  template <typename StateChangeReasonT = StepStateChangeReason>
  StepStatus& WithStateChangeReason(StateChangeReasonT&& value) {
    SetStateChangeReason(std::forward<StateChangeReasonT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The details for the step failure including reason, message, and log file path
   * where the root cause was identified.</p>
   */
  inline const FailureDetails& GetFailureDetails() const { return m_failureDetails; }
  inline bool FailureDetailsHasBeenSet() const { return m_failureDetailsHasBeenSet; }
  template <typename FailureDetailsT = FailureDetails>
  void SetFailureDetails(FailureDetailsT&& value) {
    m_failureDetailsHasBeenSet = true;
    m_failureDetails = std::forward<FailureDetailsT>(value);
  }
  template <typename FailureDetailsT = FailureDetails>
  StepStatus& WithFailureDetails(FailureDetailsT&& value) {
    SetFailureDetails(std::forward<FailureDetailsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The timeline of the cluster step status over time.</p>
   */
  inline const StepTimeline& GetTimeline() const { return m_timeline; }
  inline bool TimelineHasBeenSet() const { return m_timelineHasBeenSet; }
  template <typename TimelineT = StepTimeline>
  void SetTimeline(TimelineT&& value) {
    m_timelineHasBeenSet = true;
    m_timeline = std::forward<TimelineT>(value);
  }
  template <typename TimelineT = StepTimeline>
  StepStatus& WithTimeline(TimelineT&& value) {
    SetTimeline(std::forward<TimelineT>(value));
    return *this;
  }
  ///@}
 private:
  StepState m_state{StepState::NOT_SET};
  bool m_stateHasBeenSet = false;

  StepStateChangeReason m_stateChangeReason;
  bool m_stateChangeReasonHasBeenSet = false;

  FailureDetails m_failureDetails;
  bool m_failureDetailsHasBeenSet = false;

  StepTimeline m_timeline;
  bool m_timelineHasBeenSet = false;
};

}  // namespace Model
}  // namespace EMR
}  // namespace Aws
