﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/outposts/Outposts_EXPORTS.h>
#include <aws/outposts/model/ConnectionDetails.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Outposts {
namespace Model {
class GetConnectionResult {
 public:
  AWS_OUTPOSTS_API GetConnectionResult() = default;
  AWS_OUTPOSTS_API GetConnectionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_OUTPOSTS_API GetConnectionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> The ID of the connection. </p>
   */
  inline const Aws::String& GetConnectionId() const { return m_connectionId; }
  template <typename ConnectionIdT = Aws::String>
  void SetConnectionId(ConnectionIdT&& value) {
    m_connectionIdHasBeenSet = true;
    m_connectionId = std::forward<ConnectionIdT>(value);
  }
  template <typename ConnectionIdT = Aws::String>
  GetConnectionResult& WithConnectionId(ConnectionIdT&& value) {
    SetConnectionId(std::forward<ConnectionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Information about the connection. </p>
   */
  inline const ConnectionDetails& GetConnectionDetails() const { return m_connectionDetails; }
  template <typename ConnectionDetailsT = ConnectionDetails>
  void SetConnectionDetails(ConnectionDetailsT&& value) {
    m_connectionDetailsHasBeenSet = true;
    m_connectionDetails = std::forward<ConnectionDetailsT>(value);
  }
  template <typename ConnectionDetailsT = ConnectionDetails>
  GetConnectionResult& WithConnectionDetails(ConnectionDetailsT&& value) {
    SetConnectionDetails(std::forward<ConnectionDetailsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetConnectionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_connectionId;
  bool m_connectionIdHasBeenSet = false;

  ConnectionDetails m_connectionDetails;
  bool m_connectionDetailsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Outposts
}  // namespace Aws
