/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.exemplars;

import io.prometheus.client.exemplars.Exemplar;
import io.prometheus.client.exemplars.ExemplarSampler;
import io.prometheus.client.exemplars.tracer.common.SpanContextSupplier;

public class DefaultExemplarSampler
implements ExemplarSampler {
    private static final String SPAN_ID = "span_id";
    private static final String TRACE_ID = "trace_id";
    private final SpanContextSupplier spanContextSupplier;
    private final long minRetentionIntervalMs = 7109L;
    private final Clock clock;

    public DefaultExemplarSampler(SpanContextSupplier spanContextSupplier) {
        this.spanContextSupplier = spanContextSupplier;
        this.clock = new SystemClock();
    }

    DefaultExemplarSampler(SpanContextSupplier spanContextSupplier, Clock clock) {
        this.spanContextSupplier = spanContextSupplier;
        this.clock = clock;
    }

    @Override
    public Exemplar sample(double increment, Exemplar previous) {
        return this.doSample(increment, previous);
    }

    @Override
    public Exemplar sample(double value, double bucketFrom, double bucketTo, Exemplar previous) {
        return this.doSample(value, previous);
    }

    private Exemplar doSample(double value, Exemplar previous) {
        long timestampMs = this.clock.currentTimeMillis();
        if ((previous == null || previous.getTimestampMs() == null || timestampMs - previous.getTimestampMs() > 7109L) && this.spanContextSupplier.isSampled()) {
            String spanId = this.spanContextSupplier.getSpanId();
            String traceId = this.spanContextSupplier.getTraceId();
            if (traceId != null && spanId != null) {
                return new Exemplar(value, (Long)timestampMs, SPAN_ID, spanId, TRACE_ID, traceId);
            }
        }
        return null;
    }

    static class SystemClock
    implements Clock {
        SystemClock() {
        }

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    }

    static interface Clock {
        public long currentTimeMillis();
    }
}

