/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.cache.decorators;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ibatis.cache.Cache;

public class LruCache
implements Cache {
    private final Cache delegate;
    private Map<Object, Object> keyMap;
    private Object eldestKey;

    public LruCache(Cache delegate) {
        this.delegate = delegate;
        this.setSize(1024);
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public int getSize() {
        return this.delegate.getSize();
    }

    public void setSize(final int size) {
        this.keyMap = new LinkedHashMap<Object, Object>(this, size, 0.75f, true){
            private static final long serialVersionUID = 4267176411845948333L;
            final /* synthetic */ LruCache this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1, arg2);
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<Object, Object> eldest) {
                boolean tooBig;
                boolean bl = tooBig = this.size() > size;
                if (tooBig) {
                    this.this$0.eldestKey = eldest.getKey();
                }
                return tooBig;
            }
        };
    }

    @Override
    public void putObject(Object key, Object value) {
        this.delegate.putObject(key, value);
        this.cycleKeyList(key);
    }

    @Override
    public Object getObject(Object key) {
        this.keyMap.get(key);
        return this.delegate.getObject(key);
    }

    @Override
    public Object removeObject(Object key) {
        this.keyMap.remove(key);
        return this.delegate.removeObject(key);
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.keyMap.clear();
    }

    private void cycleKeyList(Object key) {
        this.keyMap.put(key, key);
        if (this.eldestKey != null) {
            this.delegate.removeObject(this.eldestKey);
            this.eldestKey = null;
        }
    }
}

