/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamResponse
extends SimpleSolrResponse {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Function<Integer, Boolean> HTTP_OK_VALIDATOR = status -> 200 == status;
    public static final Function<Integer, Boolean> NON_ERROR_CODE_VALIDATOR = status -> status < 399;

    @Override
    public void setResponse(NamedList<Object> rsp) {
        if (rsp.get(InputStreamResponseParser.STREAM_KEY) == null) {
            throw new IllegalArgumentException("Missing key '" + InputStreamResponseParser.STREAM_KEY + "'; " + this.getClass().getSimpleName() + " can only be used with requests or clients configured to use " + InputStreamResponseParser.class.getSimpleName());
        }
        super.setResponse(rsp);
    }

    public int getHttpStatus() {
        return (Integer)this.getResponse().get(InputStreamResponseParser.HTTP_STATUS_KEY);
    }

    public InputStream getResponseStream() {
        NamedList<Object> resp = this.getResponse();
        return (InputStream)resp.get(InputStreamResponseParser.STREAM_KEY);
    }

    public InputStream getResponseStreamIfSuccessful() {
        return this.getResponseStreamIfSuccessful(HTTP_OK_VALIDATOR);
    }

    public InputStream getResponseStreamIfSuccessful(Function<Integer, Boolean> statusValidator) {
        this.validateExpectedStatus(statusValidator);
        return this.getResponseStream();
    }

    private void validateExpectedStatus(Function<Integer, Boolean> statusChecker) {
        int httpStatus = this.getHttpStatus();
        if (!statusChecker.apply(httpStatus).booleanValue()) {
            try {
                log.error("Request returned unexpected HTTP status code {}; response content: {}", (Object)httpStatus, (Object)this.consumeAndStringifyForLogging(this.getResponseStream()));
            }
            catch (IOException e) {
                log.error("could not print error", (Throwable)e);
            }
            throw new SolrException(SolrException.ErrorCode.getErrorCode(httpStatus), "Unexpected status code [" + httpStatus + "] on response.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String consumeAndStringifyForLogging(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            inputStream.transferTo(baos);
            String string = baos.toString(Charset.defaultCharset());
            return string;
        }
        finally {
            IOUtils.closeQuietly(baos);
            IOUtils.closeQuietly(inputStream);
        }
    }
}

