/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="9.0")
public class SolrHttpRequestRetryHandler
implements HttpRequestRetryHandler {
    private static final String GET = "GET";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final SolrHttpRequestRetryHandler INSTANCE = new SolrHttpRequestRetryHandler();
    private final int retryCount;
    private final Set<Class<? extends IOException>> nonRetryableClasses;

    protected SolrHttpRequestRetryHandler(int retryCount, Collection<Class<? extends IOException>> clazzes) {
        this.retryCount = retryCount;
        this.nonRetryableClasses = new HashSet<Class<? extends IOException>>();
        for (Class<? extends IOException> clazz : clazzes) {
            this.nonRetryableClasses.add(clazz);
        }
    }

    public SolrHttpRequestRetryHandler(int retryCount) {
        this(retryCount, Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, SSLException.class));
    }

    public SolrHttpRequestRetryHandler() {
        this(3);
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        log.debug("Retry http request {} out of {}", (Object)executionCount, (Object)this.retryCount);
        if (executionCount > this.retryCount) {
            log.debug("Do not retry, over max retry count");
            return false;
        }
        if (!this.isRetryable(exception)) {
            if (log.isDebugEnabled()) {
                log.debug("Do not retry, non retryable class {}", (Object)exception.getClass().getName());
            }
            return false;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest request = clientContext.getRequest();
        if (this.requestIsAborted(request)) {
            log.debug("Do not retry, request was aborted");
            return false;
        }
        if (this.handleAsIdempotent(clientContext)) {
            log.debug("Retry, request should be idempotent");
            return true;
        }
        log.debug("Do not retry, no allow rules matched");
        return false;
    }

    private boolean isRetryable(IOException exception) {
        if (exception instanceof SSLException && Arrays.stream(exception.getSuppressed()).anyMatch(t -> t instanceof SocketException)) {
            return true;
        }
        return !this.nonRetryableClasses.contains(exception.getClass()) && !this.nonRetryableClasses.stream().anyMatch(rejectException -> rejectException.isInstance(exception));
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    protected boolean handleAsIdempotent(HttpClientContext context) {
        String method = context.getRequest().getRequestLine().getMethod();
        if (context.getRequest().getRequestLine().getUri().startsWith("/admin/")) {
            log.debug("Do not retry, this is an admin request");
            return false;
        }
        return method.equals(GET);
    }

    protected boolean requestIsAborted(HttpRequest request) {
        HttpRequest req = request;
        if (request instanceof RequestWrapper) {
            req = ((RequestWrapper)request).getOriginal();
        }
        return req instanceof HttpUriRequest && ((HttpUriRequest)req).isAborted();
    }
}

