uses dos;

var
  i, fout,
  error           : integer;
  infile,
  uitfile,
  dump            : text;
  papsizex,
  papsizey,
  filenaam,
  action,
  hsize,
  vsize,
  getal,
  regel           : string;
  bbox            : array[1..4] of real;
  x,y,
  ratio,scale,
  angle,scalex,
  scaley,
  paper_x,
  paper_y,
  null            : real;
  komma_naar_punt : boolean;
  c               : char;

procedure new_xy;
var newx,newy,minx,miny,maxx,maxy:real;

procedure new(x,y:real);
begin
  newx := x*cos(angle)-y*sin(angle);
  newy := x*sin(angle)+y*cos(angle);
  if newx < minx then minx := newx;
  if newx > maxx then maxx := newx;
  if newy < miny then miny := newy;
  if newy > maxy then maxy := newy;
end;

begin
  minx := maxint;
  miny := maxint;
  maxx := -maxint;
  maxy := -maxint;
  new(bbox[1],bbox[2]);
  new(bbox[1],bbox[4]);
  new(bbox[3],bbox[2]);
  new(bbox[3],bbox[4]);
  bbox[1] := minx;
  bbox[2] := miny;
  bbox[3] := maxx;
  bbox[4] := maxy;
end;

procedure writedump(getal:real);
VAR stringgetal    : string;
begin
  if komma_naar_punt then
  begin
    str(getal:8:4,stringgetal);
    write(stringgetal);
    if pos('.',stringgetal) > 0 then
      stringgetal := copy(stringgetal,1,pos('.',stringgetal)-1)+','+copy(stringgetal,pos('.',stringgetal)+1,256);
    writeln(dump,stringgetal);
  end
  else
    writeln(dump,getal:8:4);
end;

begin
  filenaam := paramstr(1);
  action := paramstr(2);
  val(paramstr(3),angle,error);
  if pos(',',getenv('HALF')) > 0 then
    komma_naar_punt:=true
  else
    komma_naar_punt:=false;
  angle := angle/180*pi;
  for i := 1 to 4 do bbox[i] := 0;
  scalex := 0;
  scaley := 0;
  null := 0;
  assign(infile,filenaam);
  (*$i-*)
  reset(infile);
  if ioresult <> 0 then
  begin
    writeln('File ',filenaam,' not found!!');
    halt;
  end;
  (*$i+*)
  repeat
    readln(infile,regel);
    for i := 1 to length(regel) do regel[i] := upcase(regel[i]);
  until eof(infile) or (pos('BOUNDINGBOX',regel) > 0);
  if (not eof(infile)) or (pos('BOUNDINGBOX',regel) > 0) then
  begin
    regel := copy(regel,pos('BOX',regel)+3,length(regel));
    for i := 1 to 4 do
    begin
      getal := '';
      repeat
        regel := copy(regel,2,length(regel)-1);
      until (regel[1] in ['0'..'9']) or (length(regel)=0);
      (*remove trailing blanks, check wether boundingbox is specified*)
      if length(regel) > 0 then
      begin
        repeat
          getal := getal+regel[1];
          regel := copy(regel,2,length(regel)-1);
        until (length(regel)=0) or (not (regel[1] in ['0'..'9']));
        val(getal,bbox[i],fout);
      end
      else halt;
    end;
    (*  bbox[1] = lower left x
            [2] = lower left y
            [3] = upper right x
            [4] = upper right y *)
    (*we gaan uit van papier dat papersize
      gegeven wordt in environment variables PAPERSIZEX en PAPERSIZEY
      er gaan 72 adobe punten in een inch*)
    (*first calculate rotation*)
    if angle > 0 then new_xy;
    papsizex := getenv('PAPERSIZEX');
    papsizey := getenv('PAPERSIZEY');
    hsize    := getenv('HSIZE');
    vsize    := getenv('VSIZE');
    if pos(',',papsizex) > 0 then
      papsizex := copy(papsizex,1,pos(',',papsizex)-1)+'.'+copy(papsizex,pos(',',papsizex)+1,256);
    if pos(',',papsizey) > 0 then
      papsizey := copy(papsizey,1,pos(',',papsizey)-1)+'.'+copy(papsizey,pos(',',papsizey)+1,256);
    val(papsizex,paper_x,error);
    val(papsizey,paper_y,error);
    if pos(',',hsize) > 0 then
      hsize := copy(hsize,1,pos(',',hsize)-1)+'.'+copy(hsize,pos(',',hsize)+1,256);
    if pos(',',vsize) > 0 then
      vsize := copy(vsize,1,pos(',',vsize)-1)+'.'+copy(vsize,pos(',',vsize)+1,256);
    val(hsize,x,error);
    val(vsize,y,error);
    if action='size' then
      ratio := 1
    else
    begin
      ratio := (x/(bbox[3]-bbox[1])) / (y/(bbox[4]-bbox[2]));
      if ratio > 1  then
      begin
        bbox[3] := ratio*bbox[3];
        bbox[1] := ratio*bbox[1];
      end
      else
      begin
        bbox[4] := bbox[4]/ratio;
        bbox[2] := bbox[2]/ratio;
      end;
    end;
    scalex := (paper_x*72)/(bbox[3]-bbox[1]);
    scaley := (paper_y*72)/(bbox[4]-bbox[2]);
    assign(uitfile,copy(filenaam,1,pos('.',filenaam)-1)+'.box');
    rewrite(uitfile);
    writeln(uitfile,'%!4TeX Bounding_Box expander');
    writeln(uitfile,'%%BoundingBox for the file: ',filenaam);
    if scalex < scaley then scale := scalex else scale := scaley;
    if bbox[1]*scale < 0 then
      write(uitfile,-bbox[1]*scale:4:2,' ')
    else
      write(uitfile,bbox[1]*scale:4:2,' neg ');
    if (paper_y*72)-scale*bbox[4] < 0 then
      writeln(uitfile,abs((paper_y*72)-scale*bbox[4]):4:2,' neg translate')
    else
      writeln(uitfile,(paper_y*72)-scale*bbox[4]:4:2,' translate');
    if ratio > 1 then
      writeln(uitfile,scale*ratio:2:8,' ',scale:2:8,' scale')
    else
      writeln(uitfile,scale:2:8,' ',scale/ratio:2:8,' scale');
    if angle <> 0 then writeln(uitfile,paramstr(3),' rotate');
    close(infile);
    close(uitfile);
  end;
  assign(dump,'_dump_');
  rewrite(dump);
  write(dump,'HSIZE=');
  if scalex > 0 then writedump((bbox[3]-bbox[1])/72)
     else writedump(null);
  write(dump,'VSIZE=');
  if scaley > 0 then writedump((bbox[4]-bbox[2])/72)
    else writedump(null);
  close(dump);
end.
