import javax.swing.*;

/*
 * SlideEditGUI.java
 *
 */


/**
 *
 * This class represents the GUI for editing slides.
 * It simply "has" a SlideWrapper instance and is a (graphical) interface 
 * between the user and a SlideWrapper instance.
 *
 * @author  Olle Nebendahl
 */


public class SlideEditGUI extends JFrame 
{
    private JButton deleteButton;
    private JButton undoButton;
    private JButton jButton2;
    private JButton jButton3;
    private JButton choosePrevButton;
    private JButton chooseNextButton;
    private JButton predButton;
    private JButton nextButton;
    private JButton assignTalkButton;
    private JButton jButton9;
    private JButton addToWorkingButton;
    private JButton removePredButton;
    private JButton removeSuccButton;
    
    private JComboBox predComboBox;
    private JComboBox succComboBox;
    private JEditorPane jEditorPane1;
    private JEditorPane jEditorPane2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel owningTalkLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JTextField jTextField1;
    private JTextField jTextField2;

    SlideWrapper sw;
    
    public void setVisible(boolean b)
    {
        if(!b)
        {
            getLocation(Constants.prefSlideEditGUICoordinates);
            Constants.savePreferences();
        }
        else setLocation(Constants.prefSlideEditGUICoordinates);
        super.setVisible(b);
    }
    

    /*        
    public SlideEditGUI() 
    {
        initComponents();
    }*/
    
    public SlideEditGUI(SlideWrapper wrapper) 
    {
        initComponents();
        sw=wrapper;
        load();
    }
    
    private void load()
    {
         jTextField1.setText(sw.getTitle());
         jTextField2.setText(sw.getSubject());
         jEditorPane2.setText(sw.getAnnotation());
         jEditorPane1.setText(sw.getSource());
         setTitle("edit slide");
         
         initOrder();
         initOwningTalk();
         
         pack();
    }
    
    private void flush()
    {
        if(null==sw)sw=new SlideWrapper();
        sw.setTitle(jTextField1.getText());
        sw.setSubject(jTextField2.getText());
        sw.setAnnotation(jEditorPane2.getText());
        sw.setSource(jEditorPane1.getText());
        
        saveOrder();
        //saveOwningTalk();
        
        sw.flush();
        
        pack();
    }
    

    void initOrder()
    {
        SlideRecord sr;
        
        predComboBox.removeAllItems();
        succComboBox.removeAllItems();
        
        int predLength = sw.slideOrder.pred.length;
        int succLength = sw.slideOrder.succ.length;

        int i = 0;
        
        while(i<predLength)
        {
            try
            {
                sr=SlideCache.getSlide(sw.slideOrder.pred[i++]);        
                predComboBox.addItem(sr);
            }
            catch(java.lang.NullPointerException e)
            {
                Logger.log("Here is some slideid without slide. #"+sw.slideOrder.pred[i-1]);
            }
            
        }

        i=0;
        while(i<succLength)
        {
            sr=SlideCache.getSlide(sw.slideOrder.succ[i++]);        
            succComboBox.addItem(sr);
        }
    }


    void initOwningTalk()
    {
        int i = 0;
        
        if(sw.owningTalkId!=Constants.NO_TALK_ID)
        {
            owningTalkLabel.setText(TalkCache.getTalk(sw.owningTalkId).getTitle());
        }
    }
    
    
    
    

    void saveOrder()
    {
        int l;
        int i;
        int[] list;

        l=predComboBox.getItemCount();
        list=new int[l];
        i=0;
        while(i<l)
        {   
            list[i]=((SlideRecord)predComboBox.getItemAt(i)).getSlideId();
            i++;
        }
        sw.slideOrder.pred=list;

        l=succComboBox.getItemCount();
        list=new int[l];
        i=0;
        while(i<l)
        {   
            list[i]=((SlideRecord)succComboBox.getItemAt(i)).getSlideId();
            i++;
        }
        sw.slideOrder.succ=list;
    }
    
    void saveOwningTalk()
    {
        //here seems to be nothing to do;
    }
    

    private void initComponents() {
        jPanel6 = new JPanel();
        jPanel3 = new JPanel();
        jPanel7 = new JPanel();
        jPanel4 = new JPanel();
        jPanel1 = new JPanel();
        jPanel8 = new JPanel();
        jPanel2 = new JPanel();
        jPanel5 = new JPanel();

        jButton9 = new JButton();
        undoButton = new JButton();
        deleteButton = new JButton();
        jButton2 = new JButton();
        jButton3 = new JButton();
        addToWorkingButton = new JButton();
        choosePrevButton = new JButton();
        assignTalkButton = new JButton();
        predButton = new JButton();
        chooseNextButton = new JButton();
        nextButton = new JButton();
        removePredButton = new JButton();
        removeSuccButton = new JButton();

        jLabel3 = new JLabel();
        jLabel1 = new JLabel();
        jLabel2 = new JLabel();
        owningTalkLabel = new JLabel();
        jLabel4 = new JLabel();
        jLabel5 = new JLabel();

        jTextField2 = new JTextField();
        jTextField1 = new JTextField();

        jEditorPane2 = new JEditorPane();
        jEditorPane1 = new JEditorPane();
        
        jScrollPane1 = new JScrollPane();
        
        predComboBox = new JComboBox();
        succComboBox = new JComboBox();

        getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));

        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        jPanel3.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        jLabel4.setText("title:");
        jPanel3.add(jLabel4);

        jTextField1.setText("slide doesn't have any title");
        jTextField1.setMinimumSize(new java.awt.Dimension(65, 22));
        jTextField1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                jTextField1KeyPressed(evt);
            }
        });

        jPanel3.add(jTextField1);

        jLabel5.setText("subject:");
        jPanel3.add(jLabel5);

        jTextField2.setText("slide has no subject");
        jPanel3.add(jTextField2);

        getContentPane().add(jPanel3);

        jPanel7.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        assignTalkButton.setText("talk:");
        assignTalkButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                assignTalkButtonActionPerformed(evt);
            }
        });
        jPanel7.add(assignTalkButton);

        owningTalkLabel.setText("hit \"talk:\" to attach slide to a talk");
        jPanel7.add(owningTalkLabel);

        getContentPane().add(jPanel7);

        jPanel4.setLayout(new BoxLayout(jPanel4, BoxLayout.X_AXIS));

        jLabel3.setText("key words:");
        jPanel4.add(jLabel3);

        jEditorPane2.setMaximumSize(new java.awt.Dimension(800, 216));
        jPanel4.add(jEditorPane2);

        getContentPane().add(jPanel4);

        jPanel1.setLayout(new java.awt.BorderLayout());

        jScrollPane1.setPreferredSize(new java.awt.Dimension(300, 100));
        jEditorPane1.setPreferredSize(new java.awt.Dimension(30000, 22300));
        jScrollPane1.setViewportView(jEditorPane1);

        jPanel1.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanel1);

        jPanel8.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        jButton9.setText("more...");
        jButton9.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton9ActionPerformed(evt);
            }
        });

        if(Constants.DBG)jPanel8.add(jButton9);

        getContentPane().add(jPanel8);

        deleteButton.setText("delete this slide");
        deleteButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteButtonActionPerformed(evt);
            }
        });

        jPanel2.add(deleteButton);

        undoButton.setText("undo all changes");
        undoButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                undoButtonActionPerformed(evt);
            }
        });

        jPanel2.add(undoButton);

        jButton2.setText("save changes");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jPanel2.add(jButton2);

        jButton3.setText("save as new");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        jPanel2.add(jButton3);

        getContentPane().add(jPanel2);

        getContentPane().add(new JSeparator());


        if(Constants.redundantOrder)
        {
            removePredButton.setText("remove");
            removePredButton.setToolTipText("remove selected entry from list of predecessing slides");
            removePredButton.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    removePredButtonActionPerformed(evt);
                }
            });
            jPanel5.add(removePredButton);

            choosePrevButton.setText("prev:");
            choosePrevButton.setToolTipText("hit \"prev:\" to assign previous slide");
            choosePrevButton.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    choosePrevButtonActionPerformed(evt);
                }
            });
            jPanel5.add(choosePrevButton);
        }else jPanel5.add(new JLabel("previous slide:"));

        //jLabel1.setText("hit \"prev:\" to assign previous slide");
        //jPanel5.add(jLabel1);

        predComboBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                predComboBoxItemStateChanged(evt);
            }
        });

        jPanel5.add(predComboBox);

        predButton.setText("go");
        predButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                predButtonActionPerformed(evt);
            }
        });

        jPanel5.add(predButton);
        predButton.setToolTipText("change to preceeding slide");

        getContentPane().add(jPanel5);


        removeSuccButton.setText("remove");
        removeSuccButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeSuccButtonActionPerformed(evt);
            }
        });

        jPanel6.add(removeSuccButton);


        chooseNextButton.setText("next:");
        chooseNextButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chooseNextButtonActionPerformed(evt);
            }
        });

        jPanel6.add(chooseNextButton);
        chooseNextButton.setToolTipText("hit \"next:\" to assign proceeding slide");

        //jLabel2.setText("hit \"next:\" to assign proceeding slide");
        //jPanel6.add(jLabel2);

        succComboBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                succComboBoxItemStateChanged(evt);
            }
        });

        jPanel6.add(succComboBox);

        nextButton.setText("go");
        nextButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nextButtonActionPerformed(evt);
            }
        });

        jPanel6.add(nextButton);
        nextButton.setToolTipText("change to proceeding slide");

        getContentPane().add(jPanel6);

        addToWorkingButton.setText("add this slide to working collection");
        addToWorkingButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addToWorkingButtonActionPerformed(evt);
            }
        });

        getContentPane().add(new JSeparator());

        getContentPane().add(addToWorkingButton);

        pack();
    }

    private void deleteButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        SlideCache.empty();
        SlideBelongsToTalkCache.empty();
        SlideOrderCache.empty();
        SlideConnection.deleteSlide(sw.getSlideId());
    }

    private void removeSuccButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        int i = succComboBox.getSelectedIndex();
        if((-1)==i)return;
        succComboBox.removeItemAt(i);
    }

    private void removePredButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        int i = predComboBox.getSelectedIndex();
        if((-1)==i)return;
        predComboBox.removeItemAt(i);
    }

    private void assignTalkButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        TalkRecord tr = TalkListGUI.getSelected();
        if(null!=tr)
        {
            sw.owningTalkId=tr.getTalkId();
            owningTalkLabel.setText(tr.getTitle());
        }
    }


    private void jButton9ActionPerformed(java.awt.event.ActionEvent evt) 
    {
        // morebutton
    }

    private void addToWorkingButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        WorkingPool.add(sw.getSlideId());
    }

    private void succComboBoxItemStateChanged(java.awt.event.ItemEvent evt) 
    {
        //System.out.println("succComboBoxItemStateChanged");
    }

    private void predComboBoxItemStateChanged(java.awt.event.ItemEvent evt) 
    {
        //System.out.println(predComboBox.getItemAt(predComboBox.getSelectedIndex()));
    }

    private void nextButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        //System.out.println("go next");
        SlideRecord sr=(SlideRecord)succComboBox.getSelectedItem();
        if(sr!=null)
        {
            sw.load(sr);
            load();
        }
    }

    private void predButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        //System.out.println("go previous");
        SlideRecord sr=(SlideRecord)predComboBox.getSelectedItem();
        if(sr!=null)
        {
            sw.load(sr);
            load();
        }
    }

    private void chooseNextButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        SlideRecord sr = WorkingPool.getSelected();
        if(null==sr)return;
        succComboBox.addItem((SlideRecord)sr);
        pack();
        /*int[] list = sw.slideOrder.succ;
        int l = list.length;
        sw.slideOrder.succ=new int[l+1];
        System.arraycopy(list,0,sw.slideOrder.succ,0,l);
        sw.slideOrder.succ[l]=sr.getSlideId();
        initOrder();*/
    }

    private void choosePrevButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        SlideRecord sr = WorkingPool.getSelected();
        if(null==sr)return;
        predComboBox.addItem((SlideRecord)sr);
        pack();
    }

    private void jTextField1KeyPressed(java.awt.event.KeyEvent evt) 
    {
        //if(evt.getKeyCode()==java.awt.event.KeyEvent.VK_ENTER)System.out.println("klick");
    }

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) 
    {
        Logger.log("save slide as new");
        sw.exists=false;
        flush();
    }

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) 
    {
        flush();
    }

    private void undoButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        load();
    }
    
    public static void main(String args[]) 
    {
        final SlideEditGUI seg = new SlideEditGUI(new SlideWrapper(Integer.decode(args[0]).intValue()));
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                seg.setVisible(true);
            }
        });
    }
}
